package com.tydic.llm.starter.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * LLM全局配置属性
 * 从配置文件读���: llm.*
 *
 * @author tydic
 */
@Data
@ConfigurationProperties(prefix = "llm")
public class LlmProperties {

    /**
     * 是否启用LLM功能
     */
    private Boolean enabled = true;

    /**
     * 机器人类型
     */
    private String robotType = "chatgpt";

    /**
     * 模型
     */
    private String robotModel = "gpt-3.5-turbo";

    /**
     * Token配置列表
     */
    private String tokens = "";
}
