/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.llm.starter.service.impl;

import com.alibaba.fastjson2.JSON;
import com.tydic.llm.starter.bo.LlmReqBO;
import com.tydic.llm.starter.bo.LlmRsqBO;
import com.tydic.llm.starter.config.LlmProperties;
import com.tydic.llm.starter.exception.LlmException;
import com.tydic.llm.starter.models.qwen.MessagesBO;
import com.tydic.llm.starter.models.qwen.QwenInputBO;
import com.tydic.llm.starter.models.qwen.QwenReqBO;
import com.tydic.llm.starter.models.qwen.QwenRspBO;
import com.tydic.llm.starter.service.LlmClient;
import com.tydic.llm.starter.util.HttpsUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlmClientImpl
implements LlmClient {
    private static final Logger log = LoggerFactory.getLogger(LlmClientImpl.class);
    private final LlmProperties llmProperties;

    public LlmClientImpl(LlmProperties llmProperties) {
        this.llmProperties = llmProperties;
    }

    @Override
    public LlmRsqBO chat(LlmReqBO reqBO) {
        log.info("chat llmProperties:{}", (Object)this.llmProperties.toString());
        LlmRsqBO rsqBO = new LlmRsqBO();
        if ("qwen".equals(this.llmProperties.getLlmType())) {
            try {
                String url = "https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation";
                QwenReqBO aiReqBO = new QwenReqBO();
                aiReqBO.setModel(this.llmProperties.getLlmModel());
                QwenInputBO qwenInputBO = new QwenInputBO();
                ArrayList<MessagesBO> messages = new ArrayList<MessagesBO>();
                MessagesBO messagesBO = new MessagesBO();
                messagesBO.setRole("user");
                messagesBO.setContent(reqBO.getText());
                messages.add(messagesBO);
                qwenInputBO.setMessages(messages);
                String reqParam = JSON.toJSONString((Object)aiReqBO);
                String jsonSource = HttpsUtil.sendPost(url, reqParam, this.llmProperties.getApiKey());
                log.warn("jsonSource:{}", (Object)jsonSource);
                QwenRspBO qwenRspBO = (QwenRspBO)JSON.parseObject((String)jsonSource, QwenRspBO.class);
                if (qwenRspBO.getOutput() != null) {
                    rsqBO.setContent(qwenRspBO.getOutput().getText());
                }
                rsqBO.setJsonSource(jsonSource);
                return rsqBO;
            }
            catch (Exception e) {
                throw new LlmException("\u8c03\u7528\u5927\u6a21\u578b\u5931\u8d25", e);
            }
        }
        throw new LlmException("\u6682\u4e0d\u652f\u6301\u7684\u5927\u6a21\u578b\u7c7b\u578b");
    }
}

