/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.llm.starter.config;

import com.tydic.llm.starter.config.LlmProperties;
import com.tydic.llm.starter.service.LlmClient;
import com.tydic.llm.starter.service.impl.LlmClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LlmProperties.class})
@ConditionalOnProperty(prefix="llm", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LlmAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LlmAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public LlmClient LlmClient(LlmProperties llmProperties) {
        log.info("\u521d\u59cb\u5316 LlmClient, \u914d\u7f6e\u4fe1\u606f: {}", (Object)llmProperties.toString());
        return new LlmClientImpl(llmProperties);
    }
}

