/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.llm.starter.models.qwen;

import com.alibaba.fastjson2.JSON;
import com.tydic.llm.starter.bo.LlmReqBO;
import com.tydic.llm.starter.bo.LlmRsqBO;
import com.tydic.llm.starter.config.LlmProperties;
import com.tydic.llm.starter.exception.LlmException;
import com.tydic.llm.starter.models.LlmModelService;
import com.tydic.llm.starter.models.MessagesBO;
import com.tydic.llm.starter.models.qwen.bo.QwenInputBO;
import com.tydic.llm.starter.models.qwen.bo.QwenReqBO;
import com.tydic.llm.starter.models.qwen.bo.QwenRspBO;
import com.tydic.llm.starter.util.HttpsUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QwenModelImpl
implements LlmModelService {
    private static final Logger log = LoggerFactory.getLogger(QwenModelImpl.class);

    @Override
    public LlmRsqBO chat(LlmReqBO reqBO, LlmProperties llmProperties) {
        LlmRsqBO rsqBO = new LlmRsqBO();
        try {
            String url = "https://dashscope.aliyuncs.com/api/v1/services/aigc/text-generation/generation";
            QwenReqBO aiReqBO = new QwenReqBO();
            aiReqBO.setModel(llmProperties.getLlmModel());
            QwenInputBO qwenInputBO = new QwenInputBO();
            ArrayList<MessagesBO> messages = new ArrayList<MessagesBO>();
            MessagesBO messagesBO = new MessagesBO();
            messagesBO.setRole("user");
            messagesBO.setContent(reqBO.getText());
            messages.add(messagesBO);
            qwenInputBO.setMessages(messages);
            aiReqBO.setInput(qwenInputBO);
            String reqParam = JSON.toJSONString((Object)aiReqBO);
            String jsonSource = HttpsUtil.sendPost(url, reqParam, llmProperties.getApiKey());
            log.warn("jsonSource:{}", (Object)jsonSource);
            QwenRspBO qwenRspBO = (QwenRspBO)JSON.parseObject((String)jsonSource, QwenRspBO.class);
            if (qwenRspBO.getOutput() != null) {
                rsqBO.setContent(qwenRspBO.getOutput().getText());
            }
            rsqBO.setJsonSource(jsonSource);
            return rsqBO;
        }
        catch (Exception e) {
            throw new LlmException("\u8c03\u7528\u5927\u6a21\u578b\u5931\u8d25", e);
        }
    }
}

