/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.llm.starter.models.dyc;

import com.alibaba.fastjson2.JSON;
import com.tydic.llm.starter.bo.LlmReqBO;
import com.tydic.llm.starter.bo.LlmRsqBO;
import com.tydic.llm.starter.config.LlmProperties;
import com.tydic.llm.starter.exception.LlmException;
import com.tydic.llm.starter.models.LlmModelService;
import com.tydic.llm.starter.models.MessagesBO;
import com.tydic.llm.starter.models.dyc.bo.QwenPrivateReqBO;
import com.tydic.llm.starter.models.dyc.bo.QwenPrivateRspBO;
import com.tydic.llm.starter.util.HttpsUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QwenPrivateModelImpl
implements LlmModelService {
    private static final Logger log = LoggerFactory.getLogger(QwenPrivateModelImpl.class);

    @Override
    public LlmRsqBO chat(LlmReqBO reqBO, LlmProperties llmProperties) {
        LlmRsqBO rsqBO = new LlmRsqBO();
        try {
            String url = "http://172.168.5.101:9088/v1/chat/completions";
            if (StringUtils.isNotBlank((CharSequence)llmProperties.getLlmUrl())) {
                url = llmProperties.getLlmUrl();
            }
            QwenPrivateReqBO aiReqBO = new QwenPrivateReqBO();
            aiReqBO.setModel(llmProperties.getLlmModel());
            ArrayList<MessagesBO> messages = new ArrayList<MessagesBO>();
            MessagesBO messagesBO = new MessagesBO();
            messagesBO.setRole("user");
            messagesBO.setContent(reqBO.getText());
            messages.add(messagesBO);
            aiReqBO.setMessages(messages);
            String reqParam = JSON.toJSONString((Object)aiReqBO);
            String jsonSource = HttpsUtil.sendPost(url, reqParam, llmProperties.getApiKey());
            log.warn("jsonSource:{}", (Object)jsonSource);
            QwenPrivateRspBO rspBO = (QwenPrivateRspBO)JSON.parseObject((String)jsonSource, QwenPrivateRspBO.class);
            if (rspBO.getChoices() != null) {
                rsqBO.setContent(rspBO.getChoices().get(0).getMessage().getContent());
            }
            rsqBO.setJsonSource(jsonSource);
            return rsqBO;
        }
        catch (Exception e) {
            throw new LlmException("\u8c03\u7528\u5927\u6a21\u578b\u5931\u8d25", e);
        }
    }
}

