/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.llm.starter.models.hunyuan;

import com.alibaba.fastjson2.JSON;
import com.tydic.llm.starter.bo.LlmReqBO;
import com.tydic.llm.starter.bo.LlmRsqBO;
import com.tydic.llm.starter.config.LlmProperties;
import com.tydic.llm.starter.exception.LlmException;
import com.tydic.llm.starter.models.LlmModelService;
import com.tydic.llm.starter.models.MessagesBO;
import com.tydic.llm.starter.models.hunyuan.bo.HunyuanReqBO;
import com.tydic.llm.starter.models.hunyuan.bo.HunyuanRspBO;
import com.tydic.llm.starter.util.HttpsUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HunyuanModelImpl
implements LlmModelService {
    private static final Logger log = LoggerFactory.getLogger(HunyuanModelImpl.class);

    @Override
    public LlmRsqBO chat(LlmReqBO reqBO, LlmProperties llmProperties) {
        LlmRsqBO rsqBO = new LlmRsqBO();
        try {
            String url = "https://api.hunyuan.cloud.tencent.com/v1/chat/completions";
            if (StringUtils.isNotBlank((CharSequence)llmProperties.getLlmUrl())) {
                url = llmProperties.getLlmUrl();
            }
            HunyuanReqBO aiReqBO = new HunyuanReqBO();
            aiReqBO.setModel(llmProperties.getLlmModel());
            ArrayList<MessagesBO> messages = new ArrayList<MessagesBO>();
            MessagesBO messagesBO = new MessagesBO();
            messagesBO.setRole("user");
            messagesBO.setContent(reqBO.getText());
            messages.add(messagesBO);
            aiReqBO.setMessages(messages);
            String reqParam = JSON.toJSONString((Object)aiReqBO);
            String jsonSource = HttpsUtil.sendPost(url, reqParam, llmProperties.getApiKey());
            log.warn("jsonSource:{}", (Object)jsonSource);
            HunyuanRspBO rspBO = (HunyuanRspBO)JSON.parseObject((String)jsonSource, HunyuanRspBO.class);
            if (rspBO.getChoices() != null) {
                rsqBO.setContent(rspBO.getChoices().get(0).getMessage().getContent());
            }
            rsqBO.setJsonSource(jsonSource);
            return rsqBO;
        }
        catch (Exception e) {
            throw new LlmException("\u8c03\u7528\u5927\u6a21\u578b\u5931\u8d25", e);
        }
    }
}

