/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.logistics.controller.ulc;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSONObject;
import com.tydic.logistics.api.UlcOrderCancelAbilityService;
import com.tydic.logistics.api.UlcOrderCreateAbilityService;
import com.tydic.logistics.api.UlcOrderDetailQueryAbilityService;
import com.tydic.logistics.api.UlcOrderListQueryAbilityService;
import com.tydic.logistics.api.UlcOrderStatusSyncAbilityService;
import com.tydic.logistics.api.UlcOrderTrackQueryAbilityService;
import com.tydic.logistics.api.bo.UlcOrderCancelAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderCancelAbilityRspBo;
import com.tydic.logistics.api.bo.UlcOrderCreateAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderCreateAbilityRspBo;
import com.tydic.logistics.api.bo.UlcOrderDetailQueryAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderDetailQueryAbilityRspBo;
import com.tydic.logistics.api.bo.UlcOrderListQueryAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderListQueryAbilityRspDataBo;
import com.tydic.logistics.api.bo.UlcOrderStatusSyncAbilityServiceReqBo;
import com.tydic.logistics.api.bo.UlcOrderStatusSyncAbilityServiceRspBo;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityReqBo;
import com.tydic.logistics.api.bo.UlcOrderTrackQueryAbilityRspBo;
import com.tydic.logistics.common.base.UlcPageRspBo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ulc/rest"})
public class UlcOrderController {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL")
    private UlcOrderCancelAbilityService ulcOrderCancelAbilityService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL")
    private UlcOrderCreateAbilityService ulcOrderCreateAbilityService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL")
    private UlcOrderDetailQueryAbilityService ulcOrderDetailQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL")
    private UlcOrderListQueryAbilityService ulcOrderListQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL")
    private UlcOrderStatusSyncAbilityService ulcOrderStatusSyncAbilityService;
    @HSFConsumer(serviceVersion="1.0-SNAPSHOT", serviceGroup="ULC_GROUP_LOCAL")
    private UlcOrderTrackQueryAbilityService ulcOrderTrackQueryAbilityService;

    @RequestMapping(value={"/orderCreate"}, method={RequestMethod.POST})
    @ResponseBody
    public UlcOrderCreateAbilityRspBo orderCreate(UlcOrderCreateAbilityReqBo reqBo) {
        return this.ulcOrderCreateAbilityService.dealUlcOrderCreate(reqBo);
    }

    @RequestMapping(value={"/orderCancel"}, method={RequestMethod.POST})
    @ResponseBody
    public UlcOrderCancelAbilityRspBo orderCancel(UlcOrderCancelAbilityReqBo reqBo) {
        return this.ulcOrderCancelAbilityService.dealCancel(reqBo);
    }

    @RequestMapping(value={"/qryOrderDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public UlcOrderDetailQueryAbilityRspBo qryOrderDetail(UlcOrderDetailQueryAbilityReqBo reqBo) {
        return this.ulcOrderDetailQueryAbilityService.dealUlcOrderDetailQuery(reqBo);
    }

    @RequestMapping(value={"/qryOrderList"}, method={RequestMethod.POST})
    @ResponseBody
    public UlcPageRspBo<UlcOrderListQueryAbilityRspDataBo> qryOrderList(UlcOrderListQueryAbilityReqBo reqBo) {
        return this.ulcOrderListQueryAbilityService.dealUlcOrderListQuery(reqBo);
    }

    @RequestMapping(value={"/qryOrderTrack"}, method={RequestMethod.POST})
    @ResponseBody
    public UlcOrderTrackQueryAbilityRspBo qryOrderTrack(UlcOrderTrackQueryAbilityReqBo reqBo) {
        return this.ulcOrderTrackQueryAbilityService.dealUlcOrderTrackQuery(reqBo);
    }

    @RequestMapping(value={"/emsRouteNotify"}, method={RequestMethod.POST})
    @ResponseBody
    public void emsRouteNotify(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("---------------------------------------EMS\u8def\u7531\u63a8\u9001-------------------------------------------");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            ServletInputStream inputStream = request.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            inputStream.close();
            String routeStr = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            routeStr = URLDecoder.decode(routeStr, "UTF-8");
            System.out.println("EMS\u8def\u7531\u63a8\u9001\u4fe1\u606f\u5b57\u7b26\u4e32\uff1a" + routeStr);
            this.LOGGER.info("EMS\u8def\u7531\u63a8\u9001\u4fe1\u606f\u5b57\u7b26\u4e32:" + routeStr);
            UlcOrderStatusSyncAbilityServiceReqBo abilityReqBo = new UlcOrderStatusSyncAbilityServiceReqBo();
            abilityReqBo.setCompanyId("EMS");
            abilityReqBo.setContent(routeStr);
            UlcOrderStatusSyncAbilityServiceRspBo abilityRespBo = this.ulcOrderStatusSyncAbilityService.dealStatusSys(abilityReqBo);
            String success = "1";
            String failMailNums = null;
            String remark = null;
            if (!"0000".equals(abilityRespBo.getRespCode())) {
                success = "0";
                failMailNums = abilityRespBo.getFailMailNums();
                remark = abilityRespBo.getRemark();
            }
            JSONObject resJson = new JSONObject();
            resJson.put("success", (Object)success);
            resJson.put("failmailnums", (Object)failMailNums);
            resJson.put("remark", (Object)remark);
            JSONObject backJson = new JSONObject();
            backJson.put("response", (Object)resJson);
            String backStr = backJson.toJSONString();
            this.LOGGER.info("EMS\u8def\u7531\u63a8\u9001\u8fd4\u56de\u53bb\u7684\u62a5\u6587\uff1a" + backStr);
            out.write(backStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            System.out.println("EMS\u8def\u7531\u63a8\u9001\u63a5\u6536\u5f02\u5e38\uff1a" + e);
            this.LOGGER.error("EMS\u8def\u7531\u63a8\u9001\u63a5\u6536\u5f02\u5e38" + e);
        }
    }

    @RequestMapping(value={"/sfRouteNotify"}, method={RequestMethod.POST})
    @ResponseBody
    public void dealSfRouteNotify(HttpServletRequest request, HttpServletResponse response) {
        System.out.println("--------------------------------------\u987a\u4e30\u8def\u7531\u63a8\u9001-----------------------------------------");
        this.LOGGER.info("--------------------------------------\u987a\u4e30\u8def\u7531\u63a8\u9001-----------------------------------------");
        ServletOutputStream out = null;
        StringBuilder strBuilder = new StringBuilder();
        try {
            String routeStr;
            out = response.getOutputStream();
            BufferedReader bufReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
            while ((routeStr = bufReader.readLine()) != null) {
                strBuilder.append(routeStr);
            }
            bufReader.close();
            routeStr = strBuilder.toString();
            routeStr = URLDecoder.decode(routeStr, "UTF-8");
            System.out.println("\u987a\u4e30\u8def\u7531\u63a8\u9001\u7684\u4fe1\u606f\u5b57\u7b26\u4e32\uff1a" + routeStr);
            UlcOrderStatusSyncAbilityServiceReqBo abilityReqBo = new UlcOrderStatusSyncAbilityServiceReqBo();
            abilityReqBo.setCompanyId("SF");
            abilityReqBo.setContent(routeStr);
            UlcOrderStatusSyncAbilityServiceRspBo abilityRespBo = this.ulcOrderStatusSyncAbilityService.dealStatusSys(abilityReqBo);
            System.out.println(JSONObject.toJSONString((Object)abilityRespBo));
            String head = "OK";
            String error = null;
            if (!"0000".equals(abilityRespBo.getRespCode())) {
                head = "ERR";
                error = abilityRespBo.getRemark();
            }
            String retStr = "<?xml version='1.0' encoding='UTF-8' ?><Response service='RoutePushService'><Head>" + head + "</Head><ERROR>" + error + "</ERROR></Response>";
            out.write(retStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            System.out.println("\u987a\u4e30\u8def\u7531\u63a8\u9001\u63a5\u6536\u5f02\u5e38" + e);
            this.LOGGER.error("\u987a\u4e30\u8def\u7531\u63a8\u9001\u63a5\u6536\u5f02\u5e38" + e);
        }
    }
}

