package com.tydic.lxxmmk.service.course;

import com.tydic.lxxmmk.model.student.DemoStudentModel;
import com.tydic.lxxmmk.model.student.qrybo.DemoStudentQryBo;
import com.tydic.lxxmmk.model.student.sub.DemoCourseRelation;
import com.tydic.lxxmmk.model.teather.DemoTeacherModel;
import com.tydic.lxxmmk.model.teather.qrybo.DemoTeacherQryBo;
import com.tydic.lxxmmk.model.teather.sub.DemoCourse;
import com.tydic.lxxmmk.service.course.bo.DemoCourseBo;
import com.tydic.lxxmmk.service.course.bo.DemoCourseQryReqBo;
import com.tydic.lxxmmk.service.course.bo.DemoCourseQryRsqBo;
import com.tydic.lxxmmk.service.course.bo.DemoCourseRelationBo;
import com.tydic.lxxmmk.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class DemoCourseServiceImpl implements DemoCourseService {

    @Autowired
    private DemoTeacherModel demoTeacherModel;
    @Autowired
    private DemoStudentModel demoStudentModel;

    @Override
    public DemoCourseQryRsqBo openCourse(DemoCourseQryReqBo demoCourseQryReqBo) {
        DemoCourseQryRsqBo rspBo = new DemoCourseQryRsqBo();

        DemoTeacherQryBo demoTeacherQryBo = new DemoTeacherQryBo();
        BeanUtils.copyProperties(demoCourseQryReqBo, demoTeacherQryBo);

        DemoCourse demoCourse = demoTeacherModel.openCourse(demoTeacherQryBo);

        rspBo.setDemoCourse(JsonUtil.js(demoCourse, DemoCourseBo.class));
        return rspBo;
    }

    @Override
    public DemoCourseQryRsqBo selectCourse(DemoCourseQryReqBo demoCourseQryReqBo) {
        DemoCourseQryRsqBo rspBo = new DemoCourseQryRsqBo();

        DemoStudentQryBo demoStudentQryBo = new DemoStudentQryBo();
        BeanUtils.copyProperties(demoCourseQryReqBo, demoStudentQryBo);
        DemoCourseRelation demoCourseRelation = demoStudentModel.selectCourse(demoStudentQryBo);

        rspBo.setDemoCourseRelation(JsonUtil.js(demoCourseRelation, DemoCourseRelationBo.class));
        return rspBo;
    }
}
