/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.billing.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.billing.ability.api.BillDetailsQueryAbilityService;
import com.tydic.mcmp.billing.ability.api.bo.QueryTenantBillDetailsRspBo;
import com.tydic.mcmp.billing.ability.api.bo.QueryTenantBillReqBo;
import com.tydic.mcmp.billing.dao.BillingPayTenantCdrMapper;
import com.tydic.mcmp.billing.dao.po.BillingPayTenantCdrPo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.billing.ability.api.BillDetailsQueryAbilityService"})
public class BillDetailsQueryAbilityServiceImpl
implements BillDetailsQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BillDetailsQueryAbilityServiceImpl.class);
    @Autowired
    private BillingPayTenantCdrMapper billingPayTenantCdrMapper;

    @PostMapping(value={"queryBillDetails"})
    public McmpRspPageBo<McmpRspPageDataBo<QueryTenantBillDetailsRspBo>> queryBillDetails(@RequestBody QueryTenantBillReqBo reqBo) {
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo data = new McmpRspPageDataBo();
        retBo.setData((Object)data);
        Page<BillingPayTenantCdrPo> page = this.getPage(reqBo);
        BillingPayTenantCdrPo cdrPo = new BillingPayTenantCdrPo();
        cdrPo.setResTenantId(reqBo.getTenantId());
        cdrPo.setAcctMonth(reqBo.getPayMonth());
        try {
            cdrPo.setBeginDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(reqBo.getBillStartTime()));
            cdrPo.setEndDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(reqBo.getBillEndTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<BillingPayTenantCdrPo> cdrPoList = this.billingPayTenantCdrMapper.selectByConditionPage(cdrPo, page);
        if (CollectionUtils.isEmpty(cdrPoList)) {
            log.debug("\u672a\u67e5\u8be2\u5230\u8be6\u5355\u4fe1\u606f");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be6\u5355\u4fe1\u606f");
            return retBo;
        }
        ArrayList<QueryTenantBillDetailsRspBo> rows = new ArrayList<QueryTenantBillDetailsRspBo>();
        for (BillingPayTenantCdrPo tenantCdrPo : cdrPoList) {
            QueryTenantBillDetailsRspBo dataBo = new QueryTenantBillDetailsRspBo();
            BeanUtils.copyProperties((Object)tenantCdrPo, (Object)dataBo);
            rows.add(dataBo);
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRows(rows);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Page<BillingPayTenantCdrPo> getPage(QueryTenantBillReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

