/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.billing.aop;

import java.util.Collections;
import java.util.HashMap;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@Configuration
@Order(value=-100)
public class BillingTransactionAspect {
    private static final String AOP_POINTCUT_EXPRESSION = "execution(* com.tydic.mcmp.billing.busi.impl..*(..))";
    @Autowired
    private PlatformTransactionManager transactionManager;

    @Bean
    public TransactionInterceptor txAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute requireRule = new RuleBasedTransactionAttribute();
        requireRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        requireRule.setPropagationBehavior(0);
        requireRule.setIsolationLevel(2);
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        readOnlyRule.setPropagationBehavior(4);
        readOnlyRule.setIsolationLevel(2);
        readOnlyRule.setReadOnly(true);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(16);
        txMap.put("do*", requireRule);
        txMap.put("create*", requireRule);
        txMap.put("register*", requireRule);
        txMap.put("update*", requireRule);
        txMap.put("delete*", requireRule);
        txMap.put("insert*", requireRule);
        txMap.put("add*", requireRule);
        txMap.put("modify*", requireRule);
        txMap.put("save*", requireRule);
        txMap.put("cancel*", requireRule);
        txMap.put("change*", requireRule);
        txMap.put("notify*", requireRule);
        txMap.put("break*", requireRule);
        txMap.put("marking*", requireRule);
        txMap.put("execute*", requireRule);
        txMap.put("set*", requireRule);
        txMap.put("record*", requireRule);
        txMap.put("log*", requireRule);
        txMap.put("deal*", requireRule);
        txMap.put("complete*", requireRule);
        txMap.put("batchDelete*", requireRule);
        txMap.put("batchInsert*", requireRule);
        txMap.put("on*", requireRule);
        txMap.put("query*", readOnlyRule);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
    }
}

