/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.dao.MonitorAlertCountMapper;
import com.tydic.mcmp.monitor.dao.po.MonitorAlertCountPO;
import com.tydic.mcmp.monitor.enums.MonitorSupplierEnum;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetPrivateAliyunAlertCountMetricDataServiceImpl")
public class McmpMonitorGetPrivateAliyunAlertCountMetricDataServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private MonitorAlertCountMapper monitorAlertCountMapper;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        Date start;
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(6, -7);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        Date date7Before = calendar.getTime();
        if (StringUtils.hasText((String)reqBo.getStartTime())) {
            start = new Date(Long.valueOf(reqBo.getStartTime()));
            if (start.before(date7Before)) {
                start = date7Before;
            }
        } else {
            start = date7Before;
        }
        List<MonitorAlertCountPO> platformAndTime = this.monitorAlertCountMapper.getListByPlatformAndTime(reqBo.getPlatformId(), start, new Date());
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
        metricDataBo.setInstanceId((String)reqBo.getInstanceIdList().get(0));
        ArrayList metricResultList = new ArrayList();
        if (!CollectionUtils.isEmpty(platformAndTime)) {
            Map<String, List<MonitorAlertCountPO>> collect = platformAndTime.stream().collect(Collectors.groupingBy(MonitorAlertCountPO::getPlatformId));
            collect.forEach((key, value) -> {
                McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName(key);
                MonitorSupplierEnum monitorSupplierEnum = MonitorSupplierEnum.find((String)key);
                if (null != monitorSupplierEnum) {
                    metricResultBo.setCname(monitorSupplierEnum.getSupplierName());
                }
                ArrayList metricValueList = new ArrayList();
                value.sort(Comparator.comparing(MonitorAlertCountPO::getCreateTime));
                value.forEach(data -> {
                    McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                    metricValueBo.setTimestamp(Long.toString(data.getCreateTime().getTime()));
                    metricValueBo.setVal(data.getCount().toString());
                    metricValueList.add(metricValueBo);
                });
                metricResultBo.setValues(metricValueList);
                metricResultList.add(metricResultBo);
            });
        }
        metricDataBo.setMetric(metricResultList);
        metricDataList.add(metricDataBo);
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

