/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.McmpMonitorPublicAliyunEcsMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunEcsMetricDataReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunEcsMetricDataRspBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunEcsMonitorDataBO;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetPublicAliyunEcsMetricDataServiceImpl")
public class McmpMonitorGetPublicAliyunEcsMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorPublicAliyunEcsMetricDataIntf mcmpMonitorPublicAliyunEcsMetricDataIntf;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        this.validateArgs(reqBo);
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorPublicAliyunEcsMetricDataReqBO mcmpMonitorPublicAliyunEcsMetricDataReqBo = new McmpMonitorPublicAliyunEcsMetricDataReqBO();
            mcmpMonitorPublicAliyunEcsMetricDataReqBo.setEndTime(reqBo.getEndTime());
            mcmpMonitorPublicAliyunEcsMetricDataReqBo.setPeriod(reqBo.getPeriod());
            mcmpMonitorPublicAliyunEcsMetricDataReqBo.setStartTime(reqBo.getStartTime());
            mcmpMonitorPublicAliyunEcsMetricDataReqBo.setRegionId(reqBo.getRegionId());
            mcmpMonitorPublicAliyunEcsMetricDataReqBo.setInstanceId(instanceId);
            mcmpMonitorPublicAliyunEcsMetricDataReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorPublicAliyunEcsMetricDataRspBO publicAliyunEcsMetricData = this.mcmpMonitorPublicAliyunEcsMetricDataIntf.getPublicAliyunEcsMetricData(mcmpMonitorPublicAliyunEcsMetricDataReqBo);
            if (StringUtils.hasText((String)publicAliyunEcsMetricData.getErrCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                rspBo.setErrorType(publicAliyunEcsMetricData.getErrCode());
                rspBo.setError(publicAliyunEcsMetricData.getErrMsg());
                return rspBo;
            }
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(instanceId);
            ArrayList metricResultList = new ArrayList();
            HashMap<String, McmpMonitorMetricResultBO> valueMap = new HashMap<String, McmpMonitorMetricResultBO>(16);
            publicAliyunEcsMetricData.getDataList().forEach(data -> this.transDataToMap((McmpMonitorPublicAliyunEcsMonitorDataBO)data, (Map<String, McmpMonitorMetricResultBO>)valueMap));
            valueMap.forEach((key, value) -> metricResultList.add(value));
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void transDataToMap(McmpMonitorPublicAliyunEcsMonitorDataBO data, Map<String, McmpMonitorMetricResultBO> valueMap) {
        McmpMonitorMetricValueBO valueBo;
        List valueList;
        McmpMonitorMetricResultBO metricResultBo;
        if (null != data.getCPU()) {
            metricResultBo = valueMap.get("CPU");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("CPU");
                metricResultBo.setCname("\u5b9e\u4f8bCPU\u7684\u4f7f\u7528\u6bd4\u4f8b\uff0c\u5355\u4f4d\uff1a\u767e\u5206\u6bd4\uff08%\uff09");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getCPU().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPU", metricResultBo);
        }
        if (null != data.getIntranetRX()) {
            metricResultBo = valueMap.get("IntranetRX");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("IntranetRX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u63a5\u6536\u7684\u5185\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getIntranetRX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IntranetRX", metricResultBo);
        }
        if (null != data.getIntranetTX()) {
            metricResultBo = valueMap.get("IntranetTX");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("IntranetTX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u53d1\u9001\u7684\u5185\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getIntranetTX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IntranetTX", metricResultBo);
        }
        if (null != data.getIntranetBandwidth()) {
            metricResultBo = valueMap.get("IntranetBandwidth");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("IntranetBandwidth");
                metricResultBo.setCname("\u5b9e\u4f8b\u7684\u5185\u7f51\u5e26\u5bbd\uff0c\u5355\u4f4d\u65f6\u95f4\u5185\u7684\u7f51\u7edc\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits/s");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getIntranetBandwidth().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IntranetBandwidth", metricResultBo);
        }
        if (null != data.getInternetRX()) {
            metricResultBo = valueMap.get("InternetRX");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("InternetRX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u63a5\u6536\u7684\u516c\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getInternetRX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("InternetRX", metricResultBo);
        }
        if (null != data.getInternetTX()) {
            metricResultBo = valueMap.get("InternetTX");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("InternetTX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u53d1\u9001\u7684\u516c\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getInternetTX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("InternetTX", metricResultBo);
        }
        if (null != data.getInternetBandwidth()) {
            metricResultBo = valueMap.get("InternetBandwidth");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("InternetBandwidth");
                metricResultBo.setCname("\u5b9e\u4f8b\u7684\u516c\u7f51\u5e26\u5bbd\uff0c\u5355\u4f4d\u65f6\u95f4\u5185\u7684\u7f51\u7edc\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits/s");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getInternetBandwidth().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("InternetBandwidth", metricResultBo);
        }
        if (null != data.getIOPSRead()) {
            metricResultBo = valueMap.get("IOPSRead");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("IOPSRead");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8I/O\u8bfb\u64cd\u4f5c\uff0c\u5355\u4f4d\uff1a\u6b21/s");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getIOPSRead().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IOPSRead", metricResultBo);
        }
        if (null != data.getIOPSWrite()) {
            metricResultBo = valueMap.get("IOPSWrite");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("IOPSWrite");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8I/O\u5199\u64cd\u4f5c\uff0c\u5355\u4f4d\uff1a\u6b21/s");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getIOPSWrite().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IOPSWrite", metricResultBo);
        }
        if (null != data.getBPSRead()) {
            metricResultBo = valueMap.get("BPSRead");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("BPSRead");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8\u8bfb\u5e26\u5bbd\uff0c\u5355\u4f4d\uff1aByte/s");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getBPSRead().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("BPSRead", metricResultBo);
        }
        if (null != data.getBPSWrite()) {
            metricResultBo = valueMap.get("BPSWrite");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("BPSWrite");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8\u5199\u5e26\u5bbd\uff0c\u5355\u4f4d\uff1aByte/s");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getBPSWrite().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("BPSWrite", metricResultBo);
        }
        if (null != data.getCPUCreditUsage()) {
            metricResultBo = valueMap.get("CPUCreditUsage");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("CPUCreditUsage");
                metricResultBo.setCname("\u7a81\u53d1\u6027\u80fd\u5b9e\u4f8b\u5df2\u4f7f\u7528\u7684\u79ef\u5206\u6570");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getCPU().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUCreditUsage", metricResultBo);
        }
        if (null != data.getCPUCreditBalance()) {
            metricResultBo = valueMap.get("CPUCreditBalance");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("CPUCreditBalance");
                metricResultBo.setCname("\u7a81\u53d1\u6027\u80fd\u5b9e\u4f8b\u79ef\u5206\u603b\u6570");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getCPUCreditBalance().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUCreditBalance", metricResultBo);
        }
        if (null != data.getCPUAdvanceCreditBalance()) {
            metricResultBo = valueMap.get("CPUAdvanceCreditBalance");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("CPUAdvanceCreditBalance");
                metricResultBo.setCname("\u8d85\u989d\u79ef\u5206\uff08\u7a81\u53d1\u6027\u80fd\u5b9e\u4f8b\u79ef\u5206\u8d85\u9650\u90e8\u5206\uff09");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getCPUAdvanceCreditBalance().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUAdvanceCreditBalance", metricResultBo);
        }
        if (null != data.getCPUNotpaidSurplusCreditUsage()) {
            metricResultBo = valueMap.get("CPUNotpaidSurplusCreditUsage");
            if (null == metricResultBo) {
                metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName("CPUNotpaidSurplusCreditUsage");
                metricResultBo.setCname("\u8d85\u989d\u672a\u652f\u4ed8\u79ef\u5206");
                metricResultBo.setValues(new ArrayList());
            }
            valueList = metricResultBo.getValues();
            valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(data.getTimeStamp()));
            valueBo.setVal(data.getCPUNotpaidSurplusCreditUsage().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUNotpaidSurplusCreditUsage", metricResultBo);
        }
    }

    private void validateArgs(McmpMonitorGetMetricDataReqBO reqBo) {
        if (StringUtils.hasText((String)reqBo.getPeriod())) {
            int period = Integer.parseInt(reqBo.getPeriod());
            if (!reqBo.getPeriodAC().booleanValue()) {
                if (period != 60 && period != 600 && period != 3600) {
                    throw new McmpBusinessException("MONITOR_PARAM_ERROR", "ECS\u76d1\u63a7\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\u53ea\u652f\u630160s/600s/3600s");
                }
            } else if (period < 60) {
                reqBo.setPeriod("60");
            } else if (period > 60 && period < 600) {
                reqBo.setPeriod("600");
            } else {
                reqBo.setPeriod("3600");
            }
        }
    }
}

