/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.enums.MonitorItemRdsEnum;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.McmpMonitorPublicAliyunRdsMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunRdsMetricDataReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunRdsMetricDataRspBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunRdsPerformanceKeyBO;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetPublicAliyunRdsMetricDataServiceImpl")
public class McmpMonitorGetPublicAliyunRdsMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorPublicAliyunRdsMetricDataIntf mcmpMonitorPublicAliyunRdsMetricDataIntf;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        if (!StringUtils.hasText((String)reqBo.getStartTime()) || !StringUtils.hasText((String)reqBo.getEndTime())) {
            throw new McmpBusinessException("MONITOR_PARAM_ERROR", "RDS\u76d1\u63a7\u67e5\u8be2\u8d77\u6b62\u65f6\u95f4\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorPublicAliyunRdsMetricDataReqBO mcmpMonitorPublicAliyunRdsMetricDataReqBo = new McmpMonitorPublicAliyunRdsMetricDataReqBO();
            mcmpMonitorPublicAliyunRdsMetricDataReqBo.setEndTime(reqBo.getEndTime());
            mcmpMonitorPublicAliyunRdsMetricDataReqBo.setPerformanceKeys(reqBo.getMonitorItem());
            mcmpMonitorPublicAliyunRdsMetricDataReqBo.setStartTime(reqBo.getStartTime());
            mcmpMonitorPublicAliyunRdsMetricDataReqBo.setRegionId(reqBo.getRegionId());
            mcmpMonitorPublicAliyunRdsMetricDataReqBo.setInstanceId(instanceId);
            mcmpMonitorPublicAliyunRdsMetricDataReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorPublicAliyunRdsMetricDataRspBO publicAliyunRdsMetricData = this.mcmpMonitorPublicAliyunRdsMetricDataIntf.getPublicAliyunRdsMetricData(mcmpMonitorPublicAliyunRdsMetricDataReqBo);
            if (StringUtils.hasText((String)publicAliyunRdsMetricData.getErrCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                rspBo.setErrorType(publicAliyunRdsMetricData.getErrCode());
                rspBo.setError(publicAliyunRdsMetricData.getErrMsg());
                return rspBo;
            }
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(publicAliyunRdsMetricData.getDBInstanceId());
            metricDataBo.setExp1(publicAliyunRdsMetricData.getEngine());
            ArrayList metricResultList = new ArrayList();
            publicAliyunRdsMetricData.getPerformanceKeys().forEach(data -> {
                McmpMonitorMetricResultBO metricResultBo = this.setMetricValue((McmpMonitorPublicAliyunRdsPerformanceKeyBO)data);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private McmpMonitorMetricResultBO setMetricValue(McmpMonitorPublicAliyunRdsPerformanceKeyBO data) {
        McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
        metricResultBo.setName(data.getKey());
        MonitorItemRdsEnum monitorItemRdsEnum = MonitorItemRdsEnum.find((String)data.getKey());
        if (null != monitorItemRdsEnum) {
            metricResultBo.setCname(monitorItemRdsEnum.getTitle());
        }
        ArrayList valueList = new ArrayList();
        data.getValues().forEach(dataValue -> {
            McmpMonitorMetricValueBO valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(dataValue.getDate()));
            valueBo.setVal(dataValue.getValue());
            HashMap<String, String> extMap = new HashMap<String, String>(4);
            extMap.put("unit", data.getUnit());
            extMap.put("valueFormat", data.getValueFormat());
            valueBo.setExt(extMap);
            valueList.add(valueBo);
        });
        metricResultBo.setValues(valueList);
        return metricResultBo;
    }
}

