/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.enums.MonitorItemCloudEcsEnum;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.McmpMonitorPublicAliyunCloudMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.McmpMonitorPublicAliyunCloudMetricHistoryDataIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunCloudMetricDataReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunCloudMetricDataRspBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunCloudMetricHistoryDataReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunCloudMetricHistoryDataRspBO;
import com.tydic.mcmp.monitor.intf.enums.McmpMonitorAliyunPublicCloudMetricNameSpaceEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetPublicAliyunRedisCloudMetricDataServiceImpl")
public class McmpMonitorGetPublicAliyunRedisCloudMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorPublicAliyunCloudMetricDataIntf mcmpMonitorPublicAliyunCloudMetricDataIntf;
    @Autowired
    private McmpMonitorPublicAliyunCloudMetricHistoryDataIntf mcmpMonitorPublicAliyunCloudMetricHistoryDataIntf;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        if (!StringUtils.hasText((String)reqBo.getStartTime())) {
            for (String instanceId : reqBo.getInstanceIdList()) {
                McmpMonitorPublicAliyunCloudMetricDataReqBO publicAliyunCloudMetricDataReqBo = new McmpMonitorPublicAliyunCloudMetricDataReqBO();
                publicAliyunCloudMetricDataReqBo.setNamespace(McmpMonitorAliyunPublicCloudMetricNameSpaceEnum.REDIS.getNameSpace());
                publicAliyunCloudMetricDataReqBo.setMetricName(reqBo.getMonitorItem());
                publicAliyunCloudMetricDataReqBo.setEndTime(reqBo.getEndTime());
                publicAliyunCloudMetricDataReqBo.setLength(reqBo.getPageSize());
                publicAliyunCloudMetricDataReqBo.setNextToken(reqBo.getNextToken());
                publicAliyunCloudMetricDataReqBo.setPeriod(reqBo.getPeriod());
                publicAliyunCloudMetricDataReqBo.setStartTime(reqBo.getStartTime());
                publicAliyunCloudMetricDataReqBo.setRegionId(reqBo.getRegionId());
                publicAliyunCloudMetricDataReqBo.setInstanceId(instanceId);
                publicAliyunCloudMetricDataReqBo.setDimensions("{\"instanceId\":\"" + instanceId + "\"}");
                publicAliyunCloudMetricDataReqBo.setPlatformId(reqBo.getPlatformId());
                McmpMonitorPublicAliyunCloudMetricDataRspBO publicAliyunCloudMetricDataRspBo = this.mcmpMonitorPublicAliyunCloudMetricDataIntf.getPublicAliyunEcsMetricData(publicAliyunCloudMetricDataReqBo);
                if (StringUtils.hasText((String)publicAliyunCloudMetricDataRspBo.getErrCode())) {
                    rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                    rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                    rspBo.setErrorType(publicAliyunCloudMetricDataRspBo.getErrCode());
                    rspBo.setError(publicAliyunCloudMetricDataRspBo.getErrMsg());
                    return rspBo;
                }
                if (null != publicAliyunCloudMetricDataRspBo.getSuccess() && publicAliyunCloudMetricDataRspBo.getSuccess().booleanValue() && "200".equals(publicAliyunCloudMetricDataRspBo.getCode())) {
                    JSONArray jsonArray = JSON.parseArray((String)publicAliyunCloudMetricDataRspBo.getDatapoints());
                    McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
                    metricDataBo.setInstanceId(instanceId);
                    this.setMetricValue(metricDataBo, jsonArray, publicAliyunCloudMetricDataRspBo.getNextToken(), publicAliyunCloudMetricDataRspBo.getPeriod(), reqBo);
                    metricDataList.add(metricDataBo);
                    continue;
                }
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                rspBo.setErrorType(publicAliyunCloudMetricDataRspBo.getCode());
                rspBo.setError(publicAliyunCloudMetricDataRspBo.getMessage());
                return rspBo;
            }
        } else {
            for (String instanceId : reqBo.getInstanceIdList()) {
                McmpMonitorPublicAliyunCloudMetricHistoryDataReqBO publicAliyunCloudMetricHistoryDataReqBo = new McmpMonitorPublicAliyunCloudMetricHistoryDataReqBO();
                publicAliyunCloudMetricHistoryDataReqBo.setNamespace(McmpMonitorAliyunPublicCloudMetricNameSpaceEnum.REDIS.getNameSpace());
                publicAliyunCloudMetricHistoryDataReqBo.setMetricName(reqBo.getMonitorItem());
                publicAliyunCloudMetricHistoryDataReqBo.setEndTime(reqBo.getEndTime());
                publicAliyunCloudMetricHistoryDataReqBo.setLength(reqBo.getPageSize());
                publicAliyunCloudMetricHistoryDataReqBo.setNextToken(reqBo.getNextToken());
                publicAliyunCloudMetricHistoryDataReqBo.setPeriod(reqBo.getPeriod());
                publicAliyunCloudMetricHistoryDataReqBo.setStartTime(reqBo.getStartTime());
                publicAliyunCloudMetricHistoryDataReqBo.setRegionId(reqBo.getRegionId());
                publicAliyunCloudMetricHistoryDataReqBo.setInstanceId(instanceId);
                publicAliyunCloudMetricHistoryDataReqBo.setDimensions("{\"instanceId\":\"" + instanceId + "\"}");
                publicAliyunCloudMetricHistoryDataReqBo.setPlatformId(reqBo.getPlatformId());
                McmpMonitorPublicAliyunCloudMetricHistoryDataRspBO publicAliyunCloudMetricHistoryDataRspBo = this.mcmpMonitorPublicAliyunCloudMetricHistoryDataIntf.getPublicAliyunEcsMetricHistoryData(publicAliyunCloudMetricHistoryDataReqBo);
                if (StringUtils.hasText((String)publicAliyunCloudMetricHistoryDataRspBo.getErrCode())) {
                    rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                    rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                    rspBo.setErrorType(publicAliyunCloudMetricHistoryDataRspBo.getErrCode());
                    rspBo.setError(publicAliyunCloudMetricHistoryDataRspBo.getErrMsg());
                    return rspBo;
                }
                if (null != publicAliyunCloudMetricHistoryDataRspBo.getSuccess() && publicAliyunCloudMetricHistoryDataRspBo.getSuccess().booleanValue() && "200".equals(publicAliyunCloudMetricHistoryDataRspBo.getCode())) {
                    JSONArray jsonArray = JSON.parseArray((String)publicAliyunCloudMetricHistoryDataRspBo.getDatapoints());
                    McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
                    metricDataBo.setInstanceId(instanceId);
                    this.setMetricValue(metricDataBo, jsonArray, publicAliyunCloudMetricHistoryDataRspBo.getNextToken(), publicAliyunCloudMetricHistoryDataRspBo.getPeriod(), reqBo);
                    metricDataList.add(metricDataBo);
                    continue;
                }
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                rspBo.setErrorType(publicAliyunCloudMetricHistoryDataRspBo.getCode());
                rspBo.setError(publicAliyunCloudMetricHistoryDataRspBo.getMessage());
                return rspBo;
            }
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void setMetricValue(McmpMonitorMetricDataBO metricDataBo, JSONArray jsonArray, String nextToken, String period, McmpMonitorGetMetricDataReqBO reqBo) {
        ArrayList<McmpMonitorMetricResultBO> metricResultList = new ArrayList<McmpMonitorMetricResultBO>();
        McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
        metricResultBo.setName(reqBo.getMonitorItem());
        MonitorItemCloudEcsEnum monitorItemCloudEcsEnum = MonitorItemCloudEcsEnum.find((String)reqBo.getMonitorItem());
        if (null != monitorItemCloudEcsEnum) {
            metricResultBo.setCname(monitorItemCloudEcsEnum.getTitle());
        }
        metricResultBo.setNextToken(nextToken);
        metricResultBo.setPeriod(period);
        metricResultBo.setPageSize(reqBo.getPageSize());
        ArrayList<McmpMonitorMetricValueBO> metricValueList = new ArrayList<McmpMonitorMetricValueBO>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object average;
            McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object timestamp = jsonObject.get((Object)"timestamp");
            if (null != timestamp) {
                metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(timestamp.toString()));
            }
            if (null != (average = jsonObject.get((Object)"Average"))) {
                metricValueBo.setVal(average.toString());
            }
            Map extMap = jsonObject.getInnerMap();
            extMap.remove("timestamp");
            extMap.remove("Average");
            extMap.remove("userId");
            extMap.remove("instanceId");
            if (!CollectionUtils.isEmpty((Map)extMap)) {
                metricValueBo.setExt(extMap);
            }
            metricValueList.add(metricValueBo);
        }
        metricResultBo.setValues(metricValueList);
        metricResultList.add(metricResultBo);
        metricDataBo.setMetric(metricResultList);
    }
}

