/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.enums.MonitorItemRdsEnum;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.McmpMonitorPublicAliyunRedisMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunRedisMetricDataReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunRedisMetricDataRspBO;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetPublicAliyunRedisMetricDataServiceImpl")
public class McmpMonitorGetPublicAliyunRedisMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorPublicAliyunRedisMetricDataIntf mcmpMonitorPublicAliyunRedisMetricDataIntf;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        this.validateArgs(reqBo);
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorPublicAliyunRedisMetricDataReqBO mcmpMonitorPublicAliyunRedisMetricDataReqBo = new McmpMonitorPublicAliyunRedisMetricDataReqBO();
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setEndTime(reqBo.getEndTime());
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setMonitorKeys(reqBo.getMonitorItem());
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setStartTime(reqBo.getStartTime());
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setIntervalForHistory(reqBo.getPeriod());
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setRegionId(reqBo.getRegionId());
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setInstanceId(instanceId);
            mcmpMonitorPublicAliyunRedisMetricDataReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorPublicAliyunRedisMetricDataRspBO publicAliyunRedisMetricData = this.mcmpMonitorPublicAliyunRedisMetricDataIntf.getPublicAliyunRedisMetricData(mcmpMonitorPublicAliyunRedisMetricDataReqBo);
            if (StringUtils.hasText((String)publicAliyunRedisMetricData.getErrCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                rspBo.setErrorType(publicAliyunRedisMetricData.getErrCode());
                rspBo.setError(publicAliyunRedisMetricData.getErrMsg());
                return rspBo;
            }
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(instanceId);
            HashMap<String, Map<String, Object>> timeMap = new HashMap<String, Map<String, Object>>(16);
            JSONObject monitorHistory = JSON.parseObject((String)publicAliyunRedisMetricData.getMonitorHistory());
            if (null == monitorHistory) continue;
            Map monitorHistoryInnerMap = monitorHistory.getInnerMap();
            monitorHistoryInnerMap.forEach((key, value) -> {
                Map valueMap = JSON.parseObject((String)value.toString()).getInnerMap();
                timeMap.put((String)key, valueMap);
            });
            Map<String, Map<String, Object>> resultMap = this.transResultMap(timeMap);
            ArrayList metricResultList = new ArrayList();
            resultMap.forEach((key, value) -> {
                McmpMonitorMetricResultBO metricResultBo = this.setMetricValue((String)key, (Map<String, Object>)value);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateArgs(McmpMonitorGetMetricDataReqBO reqBo) {
        block14: {
            block12: {
                Integer period;
                block13: {
                    if (!StringUtils.hasText((String)reqBo.getPeriod())) break block12;
                    period = Integer.valueOf(reqBo.getPeriod());
                    if (reqBo.getPeriodAC().booleanValue()) break block13;
                    switch (period) {
                        case 60: {
                            reqBo.setPeriod("01m");
                            break block14;
                        }
                        case 300: {
                            reqBo.setPeriod("05m");
                            break block14;
                        }
                        case 900: {
                            reqBo.setPeriod("15m");
                            break block14;
                        }
                        case 3600: {
                            reqBo.setPeriod("60m");
                            break block14;
                        }
                        default: {
                            throw new McmpBusinessException("MONITOR_PARAM_ERROR", "REDIS\u76d1\u63a7\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\u53ea\u652f\u630160s/300s/900s/3600s");
                        }
                    }
                }
                if (period < 60) {
                    reqBo.setPeriod("01m");
                } else if (period > 60 && period < 300) {
                    reqBo.setPeriod("05m");
                } else if (period > 300 && period < 900) {
                    reqBo.setPeriod("15m");
                } else {
                    reqBo.setPeriod("60m");
                }
                break block14;
            }
            throw new McmpBusinessException("MONITOR_PARAM_ERROR", "REDIS\u76d1\u63a7\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\u5fc5\u4f20\u4e14\u53ea\u652f\u630160s/300s/900s/3600s");
        }
    }

    private Map<String, Map<String, Object>> transResultMap(Map<String, Map<String, Object>> timeMap) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(16);
        HashSet monitorItemSet = new HashSet();
        timeMap.values().forEach(map -> monitorItemSet.addAll(map.keySet()));
        monitorItemSet.forEach(item -> {
            Map cfr_ignored_0 = resultMap.put((String)item, new HashMap());
        });
        timeMap.forEach((time, itemMap) -> resultMap.forEach((item, obj) -> {
            if (itemMap.containsKey(item)) {
                ((Map)resultMap.get(item)).put(time, itemMap.get(item));
            }
        }));
        return resultMap;
    }

    private McmpMonitorMetricResultBO setMetricValue(String key, Map<String, Object> value) {
        McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
        metricResultBo.setName(key);
        MonitorItemRdsEnum monitorItemRdsEnum = MonitorItemRdsEnum.find((String)key);
        if (null != monitorItemRdsEnum) {
            metricResultBo.setCname(monitorItemRdsEnum.getTitle());
        }
        ArrayList valueList = new ArrayList();
        value.forEach((time, val) -> {
            McmpMonitorMetricValueBO valueBo = new McmpMonitorMetricValueBO();
            valueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(time));
            valueBo.setVal(val.toString());
            valueList.add(valueBo);
        });
        metricResultBo.setValues(valueList);
        return metricResultBo;
    }
}

