/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetRdsResUsageReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetRdsResUsageRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetRdsResUsageCombService;
import com.tydic.mcmp.monitor.enums.MonitorSupplierEnum;
import com.tydic.mcmp.monitor.intf.api.aliyunprivate.McmpMonitorPrivateAliyunGetRdsResUsageIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunprivate.bo.McmpMonitorPrivateAliyunGetRdsResUsageReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunprivate.bo.McmpMonitorPrivateAliyunGetRdsResUsageRspBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.McmpMonitorPublicAliyunGetRdsResUsageIntf;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunGetRdsResUsageReqBO;
import com.tydic.mcmp.monitor.intf.api.aliyunpublic.bo.McmpMonitorPublicAliyunGetRdsResUsageRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class McmpMonitorGetRdsResUsageCombServiceImpl
implements McmpMonitorGetRdsResUsageCombService {
    @Autowired
    private McmpMonitorPublicAliyunGetRdsResUsageIntf mcmpMonitorPublicAliyunGetRdsResUsageIntf;
    @Autowired
    private McmpMonitorPrivateAliyunGetRdsResUsageIntf mcmpMonitorPrivateAliyunGetRdsResUsageIntf;

    @Override
    public McmpMonitorGetRdsResUsageRspBO getRdsResUsage(McmpMonitorGetRdsResUsageReqBO reqBo) {
        if (MonitorSupplierEnum.aliyun_public.getSupplierId().equals(reqBo.getPlatformId())) {
            return this.dealPublicAliyunIntf(reqBo);
        }
        if (MonitorSupplierEnum.aliyun_private.getSupplierId().equals(reqBo.getPlatformId())) {
            return this.dealPrivateAliyunIntf(reqBo);
        }
        throw new McmpBusinessException("MONITOR_PARAM_ERROR", "\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u8be5\u8d44\u6e90\u6240\u5c5e\u7684\u4f9b\u5e94\u5546");
    }

    private McmpMonitorGetRdsResUsageRspBO dealPrivateAliyunIntf(McmpMonitorGetRdsResUsageReqBO reqBo) {
        McmpMonitorGetRdsResUsageRspBO rspBo = new McmpMonitorGetRdsResUsageRspBO();
        McmpMonitorPrivateAliyunGetRdsResUsageReqBO privateAliyunGetRdsResUsageReqBo = new McmpMonitorPrivateAliyunGetRdsResUsageReqBO();
        privateAliyunGetRdsResUsageReqBo.setPlatformId(reqBo.getPlatformId());
        privateAliyunGetRdsResUsageReqBo.setInstanceId((String)reqBo.getInstanceIdList().get(0));
        McmpMonitorPrivateAliyunGetRdsResUsageRspBO privateAliyunGetRdsResUsageRspBo = this.mcmpMonitorPrivateAliyunGetRdsResUsageIntf.getPrivateAliyunRdsResUsage(privateAliyunGetRdsResUsageReqBo);
        if (StringUtils.hasText((String)privateAliyunGetRdsResUsageRspBo.getErrCode())) {
            rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
            rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38: errCode:{" + privateAliyunGetRdsResUsageRspBo.getErrCode() + "}, errMsg:{" + privateAliyunGetRdsResUsageRspBo.getErrMsg() + "}");
            return rspBo;
        }
        rspBo.setRequestId(privateAliyunGetRdsResUsageRspBo.getRequestId());
        rspBo.setDBInstanceId(privateAliyunGetRdsResUsageRspBo.getDBInstanceId());
        rspBo.setEngine(privateAliyunGetRdsResUsageRspBo.getEngine());
        rspBo.setDiskUsed(privateAliyunGetRdsResUsageRspBo.getDiskUsed());
        rspBo.setDataSize(privateAliyunGetRdsResUsageRspBo.getDataSize());
        rspBo.setLogSize(privateAliyunGetRdsResUsageRspBo.getLogSize());
        rspBo.setBackupSize(privateAliyunGetRdsResUsageRspBo.getBackupSize());
        rspBo.setBackupOssDataSize(privateAliyunGetRdsResUsageRspBo.getBackupOssDataSize());
        rspBo.setBackupOssLogSize(privateAliyunGetRdsResUsageRspBo.getBackupOssLogSize());
        rspBo.setSQLSize(privateAliyunGetRdsResUsageRspBo.getSQLSize());
        rspBo.setColdBackupSize(privateAliyunGetRdsResUsageRspBo.getColdBackupSize());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private McmpMonitorGetRdsResUsageRspBO dealPublicAliyunIntf(McmpMonitorGetRdsResUsageReqBO reqBo) {
        McmpMonitorGetRdsResUsageRspBO rspBo = new McmpMonitorGetRdsResUsageRspBO();
        McmpMonitorPublicAliyunGetRdsResUsageReqBO publicAliyunGetRdsResUsageReqBo = new McmpMonitorPublicAliyunGetRdsResUsageReqBO();
        publicAliyunGetRdsResUsageReqBo.setPlatformId(reqBo.getPlatformId());
        publicAliyunGetRdsResUsageReqBo.setInstanceId((String)reqBo.getInstanceIdList().get(0));
        McmpMonitorPublicAliyunGetRdsResUsageRspBO publicAliyunGetRdsResUsageRspBo = this.mcmpMonitorPublicAliyunGetRdsResUsageIntf.getPublicAliyunRdsResUsage(publicAliyunGetRdsResUsageReqBo);
        if (StringUtils.hasText((String)publicAliyunGetRdsResUsageRspBo.getErrCode())) {
            rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
            rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38: errCode:{" + publicAliyunGetRdsResUsageRspBo.getErrCode() + "}, errMsg:{" + publicAliyunGetRdsResUsageRspBo.getErrMsg() + "}");
            return rspBo;
        }
        rspBo.setRequestId(publicAliyunGetRdsResUsageRspBo.getRequestId());
        rspBo.setDBInstanceId(publicAliyunGetRdsResUsageRspBo.getDBInstanceId());
        rspBo.setEngine(publicAliyunGetRdsResUsageRspBo.getEngine());
        rspBo.setDiskUsed(publicAliyunGetRdsResUsageRspBo.getDiskUsed());
        rspBo.setDataSize(publicAliyunGetRdsResUsageRspBo.getDataSize());
        rspBo.setLogSize(publicAliyunGetRdsResUsageRspBo.getLogSize());
        rspBo.setBackupSize(publicAliyunGetRdsResUsageRspBo.getBackupSize());
        rspBo.setBackupOssDataSize(publicAliyunGetRdsResUsageRspBo.getBackupOssDataSize());
        rspBo.setBackupOssLogSize(publicAliyunGetRdsResUsageRspBo.getBackupOssLogSize());
        rspBo.setSQLSize(publicAliyunGetRdsResUsageRspBo.getSQLSize());
        rspBo.setColdBackupSize(publicAliyunGetRdsResUsageRspBo.getColdBackupSize());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

