/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.dao.MonitorMockMapper;
import com.tydic.mcmp.monitor.dao.po.MonitorMockPO;
import com.tydic.mcmp.monitor.enums.MonitorSupplierEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetAlertCountMetricDataServiceImpl")
public class McmpMonitorGetAlertCountMetricDataServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private MonitorMockMapper monitorMockMapper;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        Date start;
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(6, -7);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        Date date7Before = calendar.getTime();
        if (StringUtils.hasText((String)reqBo.getStartTime())) {
            start = new Date(Long.valueOf(reqBo.getStartTime()));
            if (start.before(date7Before)) {
                start = date7Before;
            }
        } else {
            start = date7Before;
        }
        List<MonitorMockPO> platformAndTime = this.monitorMockMapper.getListByConditions(reqBo.getPlatformId(), Integer.valueOf(reqBo.getPageSize()), start, now, null, "alert_count");
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
        metricDataBo.setInstanceId((String)reqBo.getInstanceIdList().get(0));
        ArrayList metricResultList = new ArrayList();
        if (!CollectionUtils.isEmpty(platformAndTime)) {
            Map<String, List<MonitorMockPO>> collect = platformAndTime.stream().collect(Collectors.groupingBy(MonitorMockPO::getPlatformId));
            collect.forEach((key, value) -> {
                McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName(key);
                MonitorSupplierEnum monitorSupplierEnum = MonitorSupplierEnum.find((String)key);
                if (null != monitorSupplierEnum) {
                    metricResultBo.setCname(monitorSupplierEnum.getSupplierName());
                }
                ArrayList metricValueList = new ArrayList();
                value.sort(Comparator.comparing(MonitorMockPO::getTimestamp));
                value.forEach(data -> {
                    McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                    metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(Long.toString(data.getTimestamp().getTime())));
                    metricValueBo.setVal(data.getCount().toString());
                    metricValueList.add(metricValueBo);
                });
                metricResultBo.setValues(metricValueList);
                metricResultList.add(metricResultBo);
            });
        }
        metricDataBo.setMetric(metricResultList);
        metricDataList.add(metricDataBo);
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

