/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetAlertHistoryReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetAlertHistoryRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetAlertHistoryCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorAlertHistoryBO;
import com.tydic.mcmp.monitor.dao.MonitorAlertHistoryMapper;
import com.tydic.mcmp.monitor.dao.po.MonitorAlertHistoryPO;
import com.tydic.mcmp.monitor.enums.MonitorSupplierEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class McmpMonitorGetAlertHistoryCombServiceImpl
implements McmpMonitorGetAlertHistoryCombService {
    @Autowired
    private MonitorAlertHistoryMapper monitorAlertHistoryMapper;

    @Override
    public McmpMonitorGetAlertHistoryRspBO getAlertHistory(McmpMonitorGetAlertHistoryReqBO reqBo) {
        McmpMonitorGetAlertHistoryRspBO rspBo = new McmpMonitorGetAlertHistoryRspBO();
        McmpRspPageDataBo rspPageDataBo = new McmpRspPageDataBo();
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        Date start = null;
        if (StringUtils.hasText((String)reqBo.getStartTime())) {
            start = McmpMonitorDateFormatTransUtil.transStrTimeToDate(reqBo.getStartTime(), "yyyy-MM-dd HH:mm:ss");
        }
        Date end = null;
        if (StringUtils.hasText((String)reqBo.getEndTime())) {
            end = McmpMonitorDateFormatTransUtil.transStrTimeToDate(reqBo.getEndTime(), "yyyy-MM-dd HH:mm:ss");
        }
        List<MonitorAlertHistoryPO> alertHistory = this.monitorAlertHistoryMapper.getListByTime(reqBo.getPlatformId(), start, end, (Page<MonitorAlertHistoryPO>)page);
        ArrayList monitorAlertHistory = new ArrayList();
        if (!CollectionUtils.isEmpty(alertHistory)) {
            alertHistory.forEach(data -> {
                McmpMonitorAlertHistoryBO monitorAlertHistoryBo = new McmpMonitorAlertHistoryBO();
                monitorAlertHistoryBo.setPlatformId(data.getPlatformId());
                MonitorSupplierEnum monitorSupplierEnum = MonitorSupplierEnum.find((String)data.getPlatformId());
                if (null != monitorSupplierEnum) {
                    monitorAlertHistoryBo.setPlatformName(monitorSupplierEnum.getSupplierName());
                }
                monitorAlertHistoryBo.setProduct(data.getProduct());
                monitorAlertHistoryBo.setInstanceId(data.getInstanceId());
                monitorAlertHistoryBo.setStatisticalItem(data.getStatisticalItem());
                monitorAlertHistoryBo.setOccurrenceTime(McmpMonitorDateFormatTransUtil.transRspDateFormat(Long.toString(data.getOccurrenceTime().getTime())));
                monitorAlertHistoryBo.setNotificationMode(data.getNotificationMode());
                monitorAlertHistoryBo.setCurrentValue(data.getCurrentValue());
                monitorAlertHistoryBo.setFaultResources(data.getFaultResources());
                monitorAlertHistory.add(monitorAlertHistoryBo);
            });
        }
        rspPageDataBo.setRows(monitorAlertHistory);
        rspPageDataBo.setPageNo(Integer.valueOf(page.getPageNo()));
        rspPageDataBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageDataBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setData((Object)rspPageDataBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

