/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorEcsMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorIntfFactory;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorEcsMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorEcsMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.enums.McmpMonitorIntfServiceTypeEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetEcsMetricDataServiceImpl")
public class McmpMonitorGetEcsMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorIntfFactory mcmpMonitorIntfFactory;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        this.validateArgs(reqBo);
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorEcsMetricDataIntf monitorEcsMetricDataIntf = this.mcmpMonitorIntfFactory.getEcsMetricData(reqBo.getPlatformId(), McmpMonitorIntfServiceTypeEnum.GET_ECS_METRIC_DATA.getServiceType());
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorEcsMetricDataIntfReqBO monitorEcsMetricDataIntfReqBo = new McmpMonitorEcsMetricDataIntfReqBO();
            monitorEcsMetricDataIntfReqBo.setEndTime(reqBo.getEndTime());
            monitorEcsMetricDataIntfReqBo.setPeriod(reqBo.getPeriod());
            monitorEcsMetricDataIntfReqBo.setStartTime(reqBo.getStartTime());
            monitorEcsMetricDataIntfReqBo.setRegionId(reqBo.getRegionId());
            monitorEcsMetricDataIntfReqBo.setInstanceId(instanceId);
            monitorEcsMetricDataIntfReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorEcsMetricDataIntfRspBO monitorEcsMetricDataIntfRspBo = monitorEcsMetricDataIntf.getEcsMetricData(monitorEcsMetricDataIntfReqBo);
            if (!"0000".equals(monitorEcsMetricDataIntfRspBo.getRespCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                if (StringUtils.hasText((String)monitorEcsMetricDataIntfRspBo.getErrCode())) {
                    rspBo.setErrorType(monitorEcsMetricDataIntfRspBo.getErrCode());
                    rspBo.setError(monitorEcsMetricDataIntfRspBo.getErrMsg());
                }
                return rspBo;
            }
            this.setMetricValue(monitorEcsMetricDataIntfRspBo.getData(), metricDataList);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void setMetricValue(List<MonitorMetricDataBO> data, List<McmpMonitorMetricDataBO> metricDataList) {
        data.forEach(resultData -> {
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(resultData.getInstanceId());
            metricDataBo.setExp1(resultData.getExp1());
            metricDataBo.setExp2(resultData.getExp2());
            metricDataBo.setExp3(resultData.getExp3());
            ArrayList metricResultList = new ArrayList();
            resultData.getMetric().forEach(result -> {
                McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName(result.getName());
                metricResultBo.setCname(result.getCname());
                metricResultBo.setNextToken(result.getNextToken());
                metricResultBo.setPageSize(result.getPageSize());
                metricResultBo.setPeriod(result.getPeriod());
                ArrayList metricValueList = new ArrayList();
                result.getValues().forEach(value -> {
                    McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                    metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(value.getTimestamp()));
                    metricValueBo.setVal(value.getVal());
                    metricValueBo.setExt(value.getExt());
                    metricValueList.add(metricValueBo);
                });
                metricResultBo.setValues(metricValueList);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        });
    }

    private void validateArgs(McmpMonitorGetMetricDataReqBO reqBo) {
        if (StringUtils.hasText((String)reqBo.getPeriod())) {
            int period = Integer.parseInt(reqBo.getPeriod());
            if (!reqBo.getPeriodAC().booleanValue()) {
                if (period != 60 && period != 600 && period != 3600) {
                    throw new McmpBusinessException("MONITOR_PARAM_ERROR", "ECS\u76d1\u63a7\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\u53ea\u652f\u630160s/600s/3600s");
                }
            } else if (period < 60) {
                reqBo.setPeriod("60");
            } else if (period > 60 && period < 600) {
                reqBo.setPeriod("600");
            } else {
                reqBo.setPeriod("3600");
            }
        }
    }
}

