/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.dao.MonitorMetricMapper;
import com.tydic.mcmp.monitor.dao.po.MonitorMetricPO;
import com.tydic.mcmp.monitor.enums.MonitorItemCloudOssEnum;
import com.tydic.mcmp.monitor.enums.MonitorMetricStatusEnum;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorCloudMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorCloudMetricHistoryDataIntf;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorIntfFactory;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricHistoryDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricHistoryDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.enums.McmpMonitorIntfServiceTypeEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetOssCloudMetricDataServiceImpl")
public class McmpMonitorGetOssCloudMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorIntfFactory mcmpMonitorIntfFactory;
    @Autowired
    private MonitorMetricMapper monitorMetricMapper;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        if (MonitorItemCloudOssEnum.MeteringCdnTX.getCode().equals(reqBo.getMonitorItem()) || MonitorItemCloudOssEnum.MeteringSyncRX.getCode().equals(reqBo.getMonitorItem()) || MonitorItemCloudOssEnum.MeteringInternetTX.getCode().equals(reqBo.getMonitorItem()) || MonitorItemCloudOssEnum.MeteringGetRequest.getCode().equals(reqBo.getMonitorItem()) || MonitorItemCloudOssEnum.MeteringPutRequest.getCode().equals(reqBo.getMonitorItem()) || MonitorItemCloudOssEnum.MeteringStorageUtilization.getCode().equals(reqBo.getMonitorItem())) {
            long period = StringUtils.hasText((String)reqBo.getPeriod()) ? Long.valueOf(reqBo.getPeriod()) : 0L;
            reqBo.setPeriod(Long.toString((period / 3600L + 1L) * 3600L));
        }
        if (!StringUtils.hasText((String)reqBo.getStartTime())) {
            return this.getLastData(reqBo);
        }
        return this.getHistoryData(reqBo);
    }

    private McmpMonitorGetMetricDataRspBO getLastData(McmpMonitorGetMetricDataReqBO reqBo) {
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorCloudMetricDataIntf monitorCloudMetricDataIntf = this.mcmpMonitorIntfFactory.getCloudMetricData(reqBo.getPlatformId(), McmpMonitorIntfServiceTypeEnum.GET_CLOUD_METRIC_DATA.getServiceType());
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorCloudMetricDataIntfReqBO monitorCloudMetricDataIntfReqBo = new McmpMonitorCloudMetricDataIntfReqBO();
            MonitorMetricPO monitorMetricPo = this.getPlatformMetricInfo(reqBo.getPlatformId(), reqBo.getNameSpace(), reqBo.getMonitorItem());
            monitorCloudMetricDataIntfReqBo.setNamespace(monitorMetricPo.getPfnamespace());
            monitorCloudMetricDataIntfReqBo.setMetricName(monitorMetricPo.getTargetmetric());
            monitorCloudMetricDataIntfReqBo.setEndTime(reqBo.getEndTime());
            monitorCloudMetricDataIntfReqBo.setLength(reqBo.getPageSize());
            monitorCloudMetricDataIntfReqBo.setNextToken(reqBo.getNextToken());
            monitorCloudMetricDataIntfReqBo.setPeriod(reqBo.getPeriod());
            monitorCloudMetricDataIntfReqBo.setStartTime(reqBo.getStartTime());
            monitorCloudMetricDataIntfReqBo.setRegionId(reqBo.getRegionId());
            monitorCloudMetricDataIntfReqBo.setExpress(StringUtils.hasText((String)reqBo.getExpress()) ? reqBo.getExpress() : this.getValueExpress(monitorMetricPo.getStatistics()));
            if (StringUtils.hasText((String)instanceId)) {
                monitorCloudMetricDataIntfReqBo.setInstanceId(instanceId);
                monitorCloudMetricDataIntfReqBo.setDimensions("{\"BucketName\":\"" + instanceId + "\"}");
            }
            monitorCloudMetricDataIntfReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorCloudMetricDataIntfRspBO monitorCloudMetricDataIntfRspBo = monitorCloudMetricDataIntf.getMetricData(monitorCloudMetricDataIntfReqBo);
            if (!"0000".equals(monitorCloudMetricDataIntfRspBo.getRespCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                if (StringUtils.hasText((String)monitorCloudMetricDataIntfRspBo.getErrCode())) {
                    rspBo.setErrorType(monitorCloudMetricDataIntfRspBo.getErrCode());
                    rspBo.setError(monitorCloudMetricDataIntfRspBo.getErrMsg());
                } else {
                    rspBo.setErrorType(monitorCloudMetricDataIntfRspBo.getCode());
                    rspBo.setError(monitorCloudMetricDataIntfRspBo.getMessage());
                }
                return rspBo;
            }
            this.setMetricValue(monitorCloudMetricDataIntfRspBo.getData(), metricDataList, reqBo, monitorMetricPo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private McmpMonitorGetMetricDataRspBO getHistoryData(McmpMonitorGetMetricDataReqBO reqBo) {
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorCloudMetricHistoryDataIntf monitorCloudMetricHistoryDataIntf = this.mcmpMonitorIntfFactory.getCloudMetricHistoryData(reqBo.getPlatformId(), McmpMonitorIntfServiceTypeEnum.GET_CLOUD_METRIC_HISTORY_DATA.getServiceType());
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorCloudMetricHistoryDataIntfReqBO monitorCloudMetricHistoryDataIntfReqBo = new McmpMonitorCloudMetricHistoryDataIntfReqBO();
            MonitorMetricPO monitorMetricPo = this.getPlatformMetricInfo(reqBo.getPlatformId(), reqBo.getNameSpace(), reqBo.getMonitorItem());
            monitorCloudMetricHistoryDataIntfReqBo.setNamespace(monitorMetricPo.getPfnamespace());
            monitorCloudMetricHistoryDataIntfReqBo.setMetricName(monitorMetricPo.getTargetmetric());
            monitorCloudMetricHistoryDataIntfReqBo.setEndTime(reqBo.getEndTime());
            monitorCloudMetricHistoryDataIntfReqBo.setLength(reqBo.getPageSize());
            monitorCloudMetricHistoryDataIntfReqBo.setNextToken(reqBo.getNextToken());
            monitorCloudMetricHistoryDataIntfReqBo.setPeriod(reqBo.getPeriod());
            monitorCloudMetricHistoryDataIntfReqBo.setStartTime(reqBo.getStartTime());
            monitorCloudMetricHistoryDataIntfReqBo.setRegionId(reqBo.getRegionId());
            if (StringUtils.hasText((String)instanceId)) {
                monitorCloudMetricHistoryDataIntfReqBo.setInstanceId(instanceId);
                monitorCloudMetricHistoryDataIntfReqBo.setDimensions("{\"BucketName\":\"" + instanceId + "\"}");
            }
            monitorCloudMetricHistoryDataIntfReqBo.setPlatformId(reqBo.getPlatformId());
            monitorCloudMetricHistoryDataIntfReqBo.setExpress(StringUtils.hasText((String)reqBo.getExpress()) ? reqBo.getExpress() : this.getValueExpress(monitorMetricPo.getStatistics()));
            McmpMonitorCloudMetricHistoryDataIntfRspBO monitorCloudMetricHistoryDataIntfRspBo = monitorCloudMetricHistoryDataIntf.getMetricHistoryData(monitorCloudMetricHistoryDataIntfReqBo);
            if (!"0000".equals(monitorCloudMetricHistoryDataIntfRspBo.getRespCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                if (StringUtils.hasText((String)monitorCloudMetricHistoryDataIntfRspBo.getErrCode())) {
                    rspBo.setErrorType(monitorCloudMetricHistoryDataIntfRspBo.getErrCode());
                    rspBo.setError(monitorCloudMetricHistoryDataIntfRspBo.getErrMsg());
                } else {
                    rspBo.setErrorType(monitorCloudMetricHistoryDataIntfRspBo.getCode());
                    rspBo.setError(monitorCloudMetricHistoryDataIntfRspBo.getMessage());
                }
                return rspBo;
            }
            this.setMetricValue(monitorCloudMetricHistoryDataIntfRspBo.getData(), metricDataList, reqBo, monitorMetricPo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private MonitorMetricPO getPlatformMetricInfo(String platformId, String namespace, String monitroItem) {
        MonitorMetricPO monitorMetricPo = new MonitorMetricPO();
        monitorMetricPo.setPfname(platformId);
        monitorMetricPo.setAlias(namespace);
        monitorMetricPo.setMetricname(monitroItem);
        monitorMetricPo.setStatus(MonitorMetricStatusEnum.AVAILABLE.getStatus());
        MonitorMetricPO metricPo = this.monitorMetricMapper.getModelBy(monitorMetricPo);
        if (null == metricPo) {
            throw new McmpBusinessException("MONITOR_QRY_DATA_NULL", "\u672a\u67e5\u8be2\u5230\u8be5\u5bf9\u5e94\u76d1\u63a7\u914d\u7f6e\u4fe1\u606f");
        }
        return metricPo;
    }

    private String getValueExpress(String express) {
        Object[] expresses = express.split(",");
        Arrays.sort(expresses);
        return expresses[0];
    }

    private void setMetricValue(List<MonitorMetricDataBO> data, List<McmpMonitorMetricDataBO> metricDataList, McmpMonitorGetMetricDataReqBO reqBo, MonitorMetricPO monitorMetric) {
        data.forEach(resultData -> {
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(resultData.getInstanceId());
            metricDataBo.setExp1(resultData.getExp1());
            metricDataBo.setExp2(resultData.getExp2());
            metricDataBo.setExp3(resultData.getExp3());
            ArrayList metricResultList = new ArrayList();
            resultData.getMetric().forEach(result -> {
                McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName(reqBo.getMonitorItem());
                metricResultBo.setCname(StringUtils.hasText((String)monitorMetric.getUnit()) ? monitorMetric.getDescription() + "(" + monitorMetric.getUnit() + ")" : monitorMetric.getDescription());
                metricResultBo.setNextToken(result.getNextToken());
                metricResultBo.setPageSize(reqBo.getPageSize());
                metricResultBo.setPeriod(result.getPeriod());
                ArrayList metricValueList = new ArrayList();
                result.getValues().forEach(value -> {
                    McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                    metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(value.getTimestamp()));
                    metricValueBo.setVal(value.getVal());
                    metricValueBo.setExt(value.getExt());
                    metricValueList.add(metricValueBo);
                });
                metricResultBo.setValues(metricValueList);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        });
    }
}

