/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.enums.MonitorItemRdsEnum;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorIntfFactory;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorRdsMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRdsMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRdsMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.enums.McmpMonitorIntfServiceTypeEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetRdsMetricDataServiceImpl")
public class McmpMonitorGetRdsMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorIntfFactory mcmpMonitorIntfFactory;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        if (!StringUtils.hasText((String)reqBo.getStartTime()) || !StringUtils.hasText((String)reqBo.getEndTime())) {
            throw new McmpBusinessException("MONITOR_PARAM_ERROR", "RDS\u76d1\u63a7\u67e5\u8be2\u8d77\u6b62\u65f6\u95f4\u6bb5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorRdsMetricDataIntf monitorRdsMetricDataIntf = this.mcmpMonitorIntfFactory.getRdsMetricData(reqBo.getPlatformId(), McmpMonitorIntfServiceTypeEnum.GET_RDS_METRIC_DATA.getServiceType());
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorRdsMetricDataIntfReqBO monitorRdsMetricDataIntfReqBo = new McmpMonitorRdsMetricDataIntfReqBO();
            monitorRdsMetricDataIntfReqBo.setEndTime(reqBo.getEndTime());
            monitorRdsMetricDataIntfReqBo.setPerformanceKeys(reqBo.getMonitorItem());
            monitorRdsMetricDataIntfReqBo.setStartTime(reqBo.getStartTime());
            monitorRdsMetricDataIntfReqBo.setRegionId(reqBo.getRegionId());
            monitorRdsMetricDataIntfReqBo.setInstanceId(instanceId);
            monitorRdsMetricDataIntfReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorRdsMetricDataIntfRspBO monitorRdsMetricDataIntfRspBo = monitorRdsMetricDataIntf.getRdsMetricData(monitorRdsMetricDataIntfReqBo);
            if (!"0000".equals(monitorRdsMetricDataIntfRspBo.getRespCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                if (StringUtils.hasText((String)monitorRdsMetricDataIntfRspBo.getErrCode())) {
                    rspBo.setErrorType(monitorRdsMetricDataIntfRspBo.getErrCode());
                    rspBo.setError(monitorRdsMetricDataIntfRspBo.getErrMsg());
                }
                return rspBo;
            }
            this.setMetricValue(monitorRdsMetricDataIntfRspBo.getData(), metricDataList, reqBo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void setMetricValue(List<MonitorMetricDataBO> data, List<McmpMonitorMetricDataBO> metricDataList, McmpMonitorGetMetricDataReqBO reqBo) {
        data.forEach(resultData -> {
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(resultData.getInstanceId());
            metricDataBo.setExp1(resultData.getExp1());
            metricDataBo.setExp2(resultData.getExp2());
            metricDataBo.setExp3(resultData.getExp3());
            ArrayList metricResultList = new ArrayList();
            resultData.getMetric().forEach(result -> {
                McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName(result.getName());
                MonitorItemRdsEnum monitorItemRdsEnum = MonitorItemRdsEnum.find((String)reqBo.getMonitorItem());
                if (null != monitorItemRdsEnum) {
                    metricResultBo.setCname(monitorItemRdsEnum.getTitle());
                }
                metricResultBo.setNextToken(result.getNextToken());
                metricResultBo.setPageSize(reqBo.getPageSize());
                metricResultBo.setPeriod(result.getPeriod());
                ArrayList metricValueList = new ArrayList();
                result.getValues().forEach(value -> {
                    McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                    metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(value.getTimestamp()));
                    metricValueBo.setVal(value.getVal());
                    metricValueBo.setExt(value.getExt());
                    metricValueList.add(metricValueBo);
                });
                metricResultBo.setValues(metricValueList);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        });
    }
}

