/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.enums.MonitorItemRedisEnum;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorIntfFactory;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorRedisMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRedisMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRedisMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.enums.McmpMonitorIntfServiceTypeEnum;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetRedisMetricDataServiceImpl")
public class McmpMonitorGetRedisMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private McmpMonitorIntfFactory mcmpMonitorIntfFactory;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        this.validateArgs(reqBo);
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorRedisMetricDataIntf monitorRedisMetricDataIntf = this.mcmpMonitorIntfFactory.getRedisMetricData(reqBo.getPlatformId(), McmpMonitorIntfServiceTypeEnum.GET_REDIS_METRIC_DATA.getServiceType());
        for (String instanceId : reqBo.getInstanceIdList()) {
            McmpMonitorRedisMetricDataIntfReqBO monitorRedisMetricDataIntfReqBo = new McmpMonitorRedisMetricDataIntfReqBO();
            monitorRedisMetricDataIntfReqBo.setEndTime(reqBo.getEndTime());
            monitorRedisMetricDataIntfReqBo.setMonitorKeys(reqBo.getMonitorItem());
            monitorRedisMetricDataIntfReqBo.setStartTime(reqBo.getStartTime());
            monitorRedisMetricDataIntfReqBo.setIntervalForHistory(reqBo.getPeriod());
            monitorRedisMetricDataIntfReqBo.setRegionId(reqBo.getRegionId());
            monitorRedisMetricDataIntfReqBo.setInstanceId(instanceId);
            monitorRedisMetricDataIntfReqBo.setPlatformId(reqBo.getPlatformId());
            McmpMonitorRedisMetricDataIntfRspBO monitorRedisMetricDataIntfRspBo = monitorRedisMetricDataIntf.getRedisMetricData(monitorRedisMetricDataIntfReqBo);
            if (!"0000".equals(monitorRedisMetricDataIntfRspBo.getRespCode())) {
                rspBo.setRespCode("MONITOR_EXT_INTF_ERROR");
                rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f02\u5e38");
                if (StringUtils.hasText((String)monitorRedisMetricDataIntfRspBo.getErrCode())) {
                    rspBo.setErrorType(monitorRedisMetricDataIntfRspBo.getErrCode());
                    rspBo.setError(monitorRedisMetricDataIntfRspBo.getErrMsg());
                }
                return rspBo;
            }
            this.setMetricValue(monitorRedisMetricDataIntfRspBo.getData(), metricDataList, reqBo);
        }
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void setMetricValue(List<MonitorMetricDataBO> data, List<McmpMonitorMetricDataBO> metricDataList, McmpMonitorGetMetricDataReqBO reqBo) {
        data.forEach(resultData -> {
            McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
            metricDataBo.setInstanceId(resultData.getInstanceId());
            metricDataBo.setExp1(resultData.getExp1());
            metricDataBo.setExp2(resultData.getExp2());
            metricDataBo.setExp3(resultData.getExp3());
            ArrayList metricResultList = new ArrayList();
            resultData.getMetric().forEach(result -> {
                McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
                metricResultBo.setName(result.getName());
                MonitorItemRedisEnum monitorItemRedisEnum = MonitorItemRedisEnum.find((String)reqBo.getMonitorItem());
                if (null != monitorItemRedisEnum) {
                    metricResultBo.setCname(monitorItemRedisEnum.getTitle());
                }
                metricResultBo.setNextToken(result.getNextToken());
                metricResultBo.setPageSize(reqBo.getPageSize());
                metricResultBo.setPeriod(result.getPeriod());
                ArrayList metricValueList = new ArrayList();
                result.getValues().forEach(value -> {
                    McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                    metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(value.getTimestamp()));
                    metricValueBo.setVal(value.getVal());
                    metricValueBo.setExt(value.getExt());
                    metricValueList.add(metricValueBo);
                });
                metricResultBo.setValues(metricValueList);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
        });
    }

    private void validateArgs(McmpMonitorGetMetricDataReqBO reqBo) {
        block14: {
            block12: {
                Integer period;
                block13: {
                    if (!StringUtils.hasText((String)reqBo.getPeriod())) break block12;
                    period = Integer.valueOf(reqBo.getPeriod());
                    if (reqBo.getPeriodAC().booleanValue()) break block13;
                    switch (period) {
                        case 60: {
                            reqBo.setPeriod("01m");
                            break block14;
                        }
                        case 300: {
                            reqBo.setPeriod("05m");
                            break block14;
                        }
                        case 900: {
                            reqBo.setPeriod("15m");
                            break block14;
                        }
                        case 3600: {
                            reqBo.setPeriod("60m");
                            break block14;
                        }
                        default: {
                            throw new McmpBusinessException("MONITOR_PARAM_ERROR", "REDIS\u76d1\u63a7\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\u53ea\u652f\u630160s/300s/900s/3600s");
                        }
                    }
                }
                if (period < 60) {
                    reqBo.setPeriod("01m");
                } else if (period > 60 && period < 300) {
                    reqBo.setPeriod("05m");
                } else if (period > 300 && period < 900) {
                    reqBo.setPeriod("15m");
                } else {
                    reqBo.setPeriod("60m");
                }
                break block14;
            }
            throw new McmpBusinessException("MONITOR_PARAM_ERROR", "REDIS\u76d1\u63a7\u67e5\u8be2\u65f6\u95f4\u95f4\u9694\u5fc5\u4f20\u4e14\u53ea\u652f\u630160s/300s/900s/3600s");
        }
    }
}

