/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.comb.impl;

import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.comb.McmpMonitorGetInstanceMetricCombService;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricDataBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricResultBO;
import com.tydic.mcmp.monitor.common.bo.McmpMonitorMetricValueBO;
import com.tydic.mcmp.monitor.dao.MonitorMockMapper;
import com.tydic.mcmp.monitor.dao.po.MonitorMockPO;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorGetTotalRedisMetricDataServiceImpl")
public class McmpMonitorGetTotalRedisMetricDataCombServiceImpl
implements McmpMonitorGetInstanceMetricCombService {
    @Autowired
    private MonitorMockMapper monitorMockMapper;

    @Override
    public McmpMonitorGetMetricDataRspBO getInstanceMetricData(McmpMonitorGetMetricDataReqBO reqBo) {
        Date start;
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(6, -7);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        Date date7Before = calendar.getTime();
        if (StringUtils.hasText((String)reqBo.getStartTime())) {
            start = new Date(Long.valueOf(reqBo.getStartTime()));
            if (start.before(date7Before)) {
                start = date7Before;
            }
        } else {
            start = date7Before;
        }
        List<MonitorMockPO> mockList = this.monitorMockMapper.getListByConditions(reqBo.getPlatformId(), Integer.valueOf(reqBo.getPageSize()), start, now, "REDIS", reqBo.getMonitorItem());
        mockList.sort(Comparator.comparing(MonitorMockPO::getTimestamp));
        ArrayList<McmpMonitorMetricDataBO> metricDataList = new ArrayList<McmpMonitorMetricDataBO>();
        McmpMonitorMetricDataBO metricDataBo = new McmpMonitorMetricDataBO();
        metricDataBo.setInstanceId((String)reqBo.getInstanceIdList().get(0));
        ArrayList<McmpMonitorMetricResultBO> metricResultList = new ArrayList<McmpMonitorMetricResultBO>();
        if (!CollectionUtils.isEmpty(mockList)) {
            McmpMonitorMetricResultBO metricResultBo = new McmpMonitorMetricResultBO();
            metricResultBo.setName(mockList.get(0).getMetricname());
            metricResultBo.setCname(mockList.get(0).getDescription() + "\uff08" + mockList.get(0).getUnit() + "\uff09");
            ArrayList metricValueList = new ArrayList();
            mockList.forEach(value -> {
                McmpMonitorMetricValueBO metricValueBo = new McmpMonitorMetricValueBO();
                metricValueBo.setTimestamp(McmpMonitorDateFormatTransUtil.transRspDateFormat(Long.toString(value.getTimestamp().getTime())));
                metricValueBo.setVal(value.getCount().toString());
                metricValueList.add(metricValueBo);
            });
            metricResultBo.setValues(metricValueList);
            metricResultList.add(metricResultBo);
        }
        metricDataBo.setMetric(metricResultList);
        metricDataList.add(metricDataBo);
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

