/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.utils;

import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataReqBO;
import com.tydic.mcmp.monitor.ability.bo.McmpMonitorGetMetricDataRspBO;
import com.tydic.mcmp.monitor.utils.McmpMonitorDateFormatTransUtil;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class McmpMonitorGetMetricDataReqArgsValidateUtil {
    public static McmpMonitorGetMetricDataRspBO validateArgs(McmpMonitorGetMetricDataReqBO reqBo) {
        McmpMonitorGetMetricDataRspBO rspBo = new McmpMonitorGetMetricDataRspBO();
        if (null == reqBo) {
            rspBo.setRespCode("MONITOR_OBJECT_NULL");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getInstanceIdList())) {
            rspBo.setRespCode("MONITOR_PARAM_NULL");
            rspBo.setRespDesc("\u5165\u53c2\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getPlatformId())) {
            rspBo.setRespCode("MONITOR_PARAM_NULL");
            rspBo.setRespDesc("\u5165\u53c2\u4e91\u5e73\u53f0ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (!StringUtils.hasText((String)reqBo.getMonitorItem())) {
            rspBo.setRespCode("MONITOR_PARAM_NULL");
            rspBo.setRespDesc("\u5165\u53c2\u76d1\u63a7\u9879\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if ("empty".equals(reqBo.getMonitorItem())) {
            reqBo.setMonitorItem(null);
        }
        if (!StringUtils.hasText((String)reqBo.getNameSpace())) {
            rspBo.setRespCode("MONITOR_PARAM_NULL");
            rspBo.setRespDesc("\u5165\u53c2\u547d\u540d\u7a7a\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (null == reqBo.getPeriodAC()) {
            reqBo.setPeriodAC(Boolean.valueOf(true));
        }
        if (!StringUtils.hasText((String)reqBo.getPageSize()) || Integer.valueOf(reqBo.getPageSize()) < 1 || Integer.valueOf(reqBo.getPageSize()) > 1000) {
            reqBo.setPageSize("100");
        }
        if (StringUtils.hasText((String)reqBo.getStartTime())) {
            reqBo.setStartTime(McmpMonitorDateFormatTransUtil.transReqDateFormat(reqBo.getStartTime()));
            reqBo.setEndTime(Long.toString(System.currentTimeMillis()));
        } else {
            reqBo.setStartTime(null);
            reqBo.setEndTime(null);
        }
        if (reqBo.getPeriodAC().booleanValue() && StringUtils.hasText((String)reqBo.getStartTime())) {
            Long start = Long.valueOf(reqBo.getStartTime());
            Long end = Long.valueOf(reqBo.getEndTime());
            long dayToMs30d = 2592000000L;
            if (end - start > dayToMs30d) {
                rspBo.setRespCode("MONITOR_PARAM_ERROR");
                rspBo.setRespDesc("\u5355\u6b21\u6700\u591a\u80fd\u67e5\u8be2\u8fd130\u5929\u5185\u7684\u76d1\u63a7\u4fe1\u606f");
                return rspBo;
            }
            long period = (end / 1000L - start / 1000L) / Long.valueOf(reqBo.getPageSize());
            reqBo.setPeriod(Long.toString((period / 300L + 1L) * 300L));
        }
        return null;
    }
}

