/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.service.aliyunprivate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.cms.model.v20190101.DescribeMetricListRequest;
import com.aliyuncs.cms.model.v20190101.DescribeMetricListResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorCloudMetricHistoryDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricHistoryDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricHistoryDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricResultBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.McmpMonitorGetResourceDetailIntf;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailReqBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailRspBO;
import com.tydic.mcmp.monitor.intf.utils.PrivateAcsClient;
import com.tydic.mcmp.monitor.intf.utils.PrivateAcsClientUtil;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="mcmpMonitorPrivateAliyunCloudMetricHistoryDataIntfImpl")
public class McmpMonitorPrivateAliyunCloudMetricHistoryDataIntfImpl
implements McmpMonitorCloudMetricHistoryDataIntf {
    private static final Logger log = LoggerFactory.getLogger(McmpMonitorPrivateAliyunCloudMetricHistoryDataIntfImpl.class);
    @Autowired
    private PrivateAcsClientUtil privateAcsClientUtil;
    @Autowired
    private McmpMonitorGetResourceDetailIntf mcmpMonitorGetResourceDetailIntf;

    @Override
    public McmpMonitorCloudMetricHistoryDataIntfRspBO getMetricHistoryData(McmpMonitorCloudMetricHistoryDataIntfReqBO reqBo) {
        McmpMonitorCloudMetricHistoryDataIntfRspBO rspBo = new McmpMonitorCloudMetricHistoryDataIntfRspBO();
        String instanceId = reqBo.getInstanceId();
        McmpMonitorgetResourceDetailReqBO resourceDetailReqBo = new McmpMonitorgetResourceDetailReqBO();
        resourceDetailReqBo.setInstanceId(instanceId);
        resourceDetailReqBo.setPlatformId(reqBo.getPlatformId());
        McmpMonitorgetResourceDetailRspBO resourceDetailRspBo = this.mcmpMonitorGetResourceDetailIntf.getResourceDetail(resourceDetailReqBo);
        if (!"0000".equals(resourceDetailRspBo.getRespCode())) {
            throw new McmpBusinessException("8888", "\u67e5\u8be2\u8d44\u6e90\u8be6\u60c5\u5931\u8d25");
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)resourceDetailRspBo.getRegionId(), (String)resourceDetailRspBo.getAccessKeyId(), (String)resourceDetailRspBo.getAccessKeySecret());
        PrivateAcsClient iAcsClient = this.privateAcsClientUtil.getInstance(profile, resourceDetailRspBo.getRegionId(), instanceId, resourceDetailRspBo.getProxyHost(), resourceDetailRspBo.getProxyPort(), resourceDetailRspBo.getEndpoint());
        DescribeMetricListRequest request = new DescribeMetricListRequest();
        request.setDimensions(reqBo.getDimensions());
        request.setEndTime(reqBo.getEndTime());
        request.setLength(reqBo.getLength());
        request.setMetricName(reqBo.getMetricName());
        request.setNamespace(reqBo.getNamespace());
        request.setNextToken(reqBo.getNextToken());
        request.setPeriod(reqBo.getPeriod());
        request.setStartTime(reqBo.getStartTime());
        try {
            log.debug("\u8c03\u7528\u79c1\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            DescribeMetricListResponse response = (DescribeMetricListResponse)iAcsClient.getAcsResponse((AcsRequest)request);
            log.debug("\u8c03\u7528\u79c1\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)response));
            if (null != response && null != response.getSuccess() && response.getSuccess().booleanValue() && "200".equals(response.getCode())) {
                ArrayList<MonitorMetricDataBO> metricDataList = new ArrayList<MonitorMetricDataBO>();
                JSONArray jsonArray = JSON.parseArray((String)response.getDatapoints());
                MonitorMetricDataBO metricDataBo = new MonitorMetricDataBO();
                metricDataBo.setInstanceId(instanceId);
                this.setMetricValue(metricDataBo, jsonArray, response.getNextToken(), response.getPeriod(), reqBo);
                metricDataList.add(metricDataBo);
                rspBo.setData(metricDataList);
                rspBo.setCode(response.getCode());
                rspBo.setMessage(response.getMessage());
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
            } else {
                if (null != response) {
                    rspBo.setCode(response.getCode());
                    rspBo.setMessage(response.getMessage());
                }
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u67e5\u8be2\u963f\u91cc\u79c1\u6709\u4e91\u4e91\u76d1\u63a7\u5386\u53f2\u4fe1\u606f\u5f02\u5e38");
            }
            return rspBo;
        }
        catch (ClientException e) {
            log.error("\u8c03\u7528\u79c1\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            rspBo.setErrCode(e.getErrCode());
            rspBo.setErrMsg(e.getErrMsg());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u963f\u91cc\u79c1\u6709\u4e91\u4e91\u76d1\u63a7\u5386\u53f2\u4fe1\u606f\u5f02\u5e38");
            return rspBo;
        }
    }

    private void setMetricValue(MonitorMetricDataBO metricDataBo, JSONArray jsonArray, String nextToken, String period, McmpMonitorCloudMetricHistoryDataIntfReqBO reqBo) {
        ArrayList<MonitorMetricResultBO> metricResultList = new ArrayList<MonitorMetricResultBO>();
        MonitorMetricResultBO metricResultBo = new MonitorMetricResultBO();
        metricResultBo.setName(reqBo.getMetricName());
        metricResultBo.setNextToken(nextToken);
        metricResultBo.setPeriod(period);
        ArrayList<MonitorMetricValueBO> metricValueList = new ArrayList<MonitorMetricValueBO>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object average;
            MonitorMetricValueBO metricValueBo = new MonitorMetricValueBO();
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object timestamp = jsonObject.get((Object)"timestamp");
            if (null != timestamp) {
                metricValueBo.setTimestamp(timestamp.toString());
            }
            if (null != (average = jsonObject.get((Object)reqBo.getExpress()))) {
                metricValueBo.setVal(average.toString());
            }
            Map extMap = jsonObject.getInnerMap();
            extMap.remove("timestamp");
            extMap.remove("userId");
            extMap.remove("instanceId");
            if (!CollectionUtils.isEmpty((Map)extMap)) {
                metricValueBo.setExt(extMap);
            }
            metricValueList.add(metricValueBo);
        }
        metricResultBo.setValues(metricValueList);
        metricResultList.add(metricResultBo);
        metricDataBo.setMetric(metricResultList);
    }
}

