/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.service.aliyunprivate;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.ecs.model.v20140526.DescribeInstanceMonitorDataRequest;
import com.aliyuncs.ecs.model.v20140526.DescribeInstanceMonitorDataResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorEcsMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorEcsMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorEcsMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricResultBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.McmpMonitorGetResourceDetailIntf;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailReqBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailRspBO;
import com.tydic.mcmp.monitor.intf.utils.PrivateAcsClient;
import com.tydic.mcmp.monitor.intf.utils.PrivateAcsClientUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorPrivateAliyunEcsMetricDataIntfImpl")
public class McmpMonitorPrivateAliyunEcsMetricDataIntfImpl
implements McmpMonitorEcsMetricDataIntf {
    private static final Logger log = LoggerFactory.getLogger(McmpMonitorPrivateAliyunEcsMetricDataIntfImpl.class);
    @Autowired
    private PrivateAcsClientUtil privateAcsClientUtil;
    @Autowired
    private McmpMonitorGetResourceDetailIntf mcmpMonitorGetResourceDetailIntf;

    @Override
    public McmpMonitorEcsMetricDataIntfRspBO getEcsMetricData(McmpMonitorEcsMetricDataIntfReqBO reqBo) {
        McmpMonitorEcsMetricDataIntfRspBO rspBo = new McmpMonitorEcsMetricDataIntfRspBO();
        String instanceId = reqBo.getInstanceId();
        McmpMonitorgetResourceDetailReqBO resourceDetailReqBo = new McmpMonitorgetResourceDetailReqBO();
        resourceDetailReqBo.setInstanceId(instanceId);
        resourceDetailReqBo.setPlatformId(reqBo.getPlatformId());
        McmpMonitorgetResourceDetailRspBO resourceDetailRspBo = this.mcmpMonitorGetResourceDetailIntf.getResourceDetail(resourceDetailReqBo);
        if (!"0000".equals(resourceDetailRspBo.getRespCode())) {
            throw new McmpBusinessException("8888", "\u67e5\u8be2\u8d44\u6e90\u8be6\u60c5\u5931\u8d25");
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)resourceDetailRspBo.getRegionId(), (String)resourceDetailRspBo.getAccessKeyId(), (String)resourceDetailRspBo.getAccessKeySecret());
        PrivateAcsClient iAcsClient = this.privateAcsClientUtil.getInstance(profile, resourceDetailRspBo.getRegionId(), instanceId, resourceDetailRspBo.getProxyHost(), resourceDetailRspBo.getProxyPort(), resourceDetailRspBo.getEndpoint());
        DescribeInstanceMonitorDataRequest request = new DescribeInstanceMonitorDataRequest();
        request.setInstanceId(instanceId);
        long currentTimeMillis = System.currentTimeMillis();
        if (!StringUtils.hasText((String)reqBo.getStartTime())) {
            reqBo.setStartTime(String.valueOf(currentTimeMillis - 60000L));
        }
        request.setStartTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date(Long.valueOf(reqBo.getStartTime()))));
        if (!StringUtils.hasText((String)reqBo.getEndTime())) {
            reqBo.setEndTime(String.valueOf(currentTimeMillis));
        }
        request.setEndTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date(Long.valueOf(reqBo.getEndTime()))));
        request.setPeriod(StringUtils.hasText((String)reqBo.getPeriod()) ? Integer.valueOf(reqBo.getPeriod()) : null);
        try {
            log.debug("\u8c03\u7528\u79c1\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            DescribeInstanceMonitorDataResponse response = (DescribeInstanceMonitorDataResponse)iAcsClient.getAcsResponse((AcsRequest)request);
            System.out.println("--------------------\u67e5\u8be2ECS\u6240\u6709\u76f8\u5173\u7684\u76d1\u63a7\u4fe1\u606f--------------------");
            log.debug("\u8c03\u7528\u79c1\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)response));
            ArrayList<MonitorMetricDataBO> metricDataList = new ArrayList<MonitorMetricDataBO>();
            MonitorMetricDataBO metricDataBo = new MonitorMetricDataBO();
            metricDataBo.setInstanceId(instanceId);
            ArrayList<MonitorMetricResultBO> metricResultList = new ArrayList<MonitorMetricResultBO>();
            HashMap<String, MonitorMetricResultBO> valueMap = new HashMap<String, MonitorMetricResultBO>(16);
            response.getMonitorData().forEach(data -> this.transDataToMap((DescribeInstanceMonitorDataResponse.InstanceMonitorData)data, (Map<String, MonitorMetricResultBO>)valueMap));
            valueMap.forEach((key, value) -> metricResultList.add((MonitorMetricResultBO)value));
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
            rspBo.setData(metricDataList);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        catch (ClientException e) {
            log.error("\u8c03\u7528\u79c1\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            rspBo.setErrCode(e.getErrCode());
            rspBo.setErrMsg(e.getErrMsg());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u963f\u91cc\u79c1\u6709\u4e91ECS\u76d1\u63a7\u6570\u636e\u5f02\u5e38");
            return rspBo;
        }
    }

    private void transDataToMap(DescribeInstanceMonitorDataResponse.InstanceMonitorData data, Map<String, MonitorMetricResultBO> valueMap) {
        MonitorMetricValueBO valueBo;
        List<MonitorMetricValueBO> valueList;
        MonitorMetricResultBO metricResultBo;
        if (null != data.getCPU()) {
            metricResultBo = valueMap.get("CPU");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("CPU");
                metricResultBo.setCname("\u5b9e\u4f8bvcpu\u7684\u4f7f\u7528\u6bd4\u4f8b\uff0c\u5355\u4f4d\uff1a\u767e\u5206\u6bd4\uff08%\uff09");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getCPU().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPU", metricResultBo);
        }
        if (null != data.getIntranetRX()) {
            metricResultBo = valueMap.get("IntranetRX");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("IntranetRX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u63a5\u6536\u7684\u5185\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getIntranetRX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IntranetRX", metricResultBo);
        }
        if (null != data.getIntranetTX()) {
            metricResultBo = valueMap.get("IntranetTX");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("IntranetTX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u53d1\u9001\u7684\u5185\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getIntranetTX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IntranetTX", metricResultBo);
        }
        if (null != data.getIntranetBandwidth()) {
            metricResultBo = valueMap.get("IntranetBandwidth");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("IntranetBandwidth");
                metricResultBo.setCname("\u5b9e\u4f8b\u7684\u5185\u7f51\u5e26\u5bbd\uff0c\u5355\u4f4d\u65f6\u95f4\u5185\u7684\u7f51\u7edc\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits/s");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getIntranetBandwidth().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IntranetBandwidth", metricResultBo);
        }
        if (null != data.getInternetRX()) {
            metricResultBo = valueMap.get("InternetRX");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("InternetRX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u63a5\u6536\u7684\u516c\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getInternetRX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("InternetRX", metricResultBo);
        }
        if (null != data.getInternetTX()) {
            metricResultBo = valueMap.get("InternetTX");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("InternetTX");
                metricResultBo.setCname("\u5b9e\u4f8b\u5728TimeStamp\u65f6\u523b\u53d1\u9001\u7684\u516c\u7f51\u6570\u636e\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getInternetTX().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("InternetTX", metricResultBo);
        }
        if (null != data.getInternetBandwidth()) {
            metricResultBo = valueMap.get("InternetBandwidth");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("InternetBandwidth");
                metricResultBo.setCname("\u5b9e\u4f8b\u7684\u516c\u7f51\u5e26\u5bbd\uff0c\u5355\u4f4d\u65f6\u95f4\u5185\u7684\u7f51\u7edc\u6d41\u91cf\uff0c\u5355\u4f4d\uff1akbits/s");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getInternetBandwidth().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("InternetBandwidth", metricResultBo);
        }
        if (null != data.getIOPSRead()) {
            metricResultBo = valueMap.get("IOPSRead");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("IOPSRead");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8I/O\u8bfb\u64cd\u4f5c\uff0c\u5355\u4f4d\uff1a\u6b21/s");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getIOPSRead().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IOPSRead", metricResultBo);
        }
        if (null != data.getIOPSWrite()) {
            metricResultBo = valueMap.get("IOPSWrite");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("IOPSWrite");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8I/O\u5199\u64cd\u4f5c\uff0c\u5355\u4f4d\uff1a\u6b21/s");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getIOPSWrite().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("IOPSWrite", metricResultBo);
        }
        if (null != data.getBPSRead()) {
            metricResultBo = valueMap.get("BPSRead");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("BPSRead");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8\u8bfb\u5e26\u5bbd\uff0c\u5355\u4f4d\uff1aByte/s");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getBPSRead().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("BPSRead", metricResultBo);
        }
        if (null != data.getBPSWrite()) {
            metricResultBo = valueMap.get("BPSWrite");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("BPSWrite");
                metricResultBo.setCname("\u5b9e\u4f8b\u7cfb\u7edf\u76d8\u5199\u5e26\u5bbd\uff0c\u5355\u4f4d\uff1aByte/s");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getBPSWrite().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("BPSWrite", metricResultBo);
        }
        if (null != data.getCPUCreditUsage()) {
            metricResultBo = valueMap.get("CPUCreditUsage");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("CPUCreditUsage");
                metricResultBo.setCname("\u7a81\u53d1\u6027\u80fd\u5b9e\u4f8b\u5df2\u4f7f\u7528\u7684\u79ef\u5206\u6570");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getCPU().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUCreditUsage", metricResultBo);
        }
        if (null != data.getCPUCreditBalance()) {
            metricResultBo = valueMap.get("CPUCreditBalance");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("CPUCreditBalance");
                metricResultBo.setCname("\u7a81\u53d1\u6027\u80fd\u5b9e\u4f8b\u79ef\u5206\u603b\u6570");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getCPUCreditBalance().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUCreditBalance", metricResultBo);
        }
        if (null != data.getCPUAdvanceCreditBalance()) {
            metricResultBo = valueMap.get("CPUAdvanceCreditBalance");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("CPUAdvanceCreditBalance");
                metricResultBo.setCname("\u8d85\u989d\u79ef\u5206\uff08\u7a81\u53d1\u6027\u80fd\u5b9e\u4f8b\u79ef\u5206\u8d85\u9650\u90e8\u5206\uff09");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getCPUAdvanceCreditBalance().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUAdvanceCreditBalance", metricResultBo);
        }
        if (null != data.getCPUNotpaidSurplusCreditUsage()) {
            metricResultBo = valueMap.get("CPUNotpaidSurplusCreditUsage");
            if (null == metricResultBo) {
                metricResultBo = new MonitorMetricResultBO();
                metricResultBo.setName("CPUNotpaidSurplusCreditUsage");
                metricResultBo.setCname("\u8d85\u989d\u672a\u652f\u4ed8\u79ef\u5206");
                metricResultBo.setValues(new ArrayList<MonitorMetricValueBO>());
            }
            valueList = metricResultBo.getValues();
            valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(data.getTimeStamp());
            valueBo.setVal(data.getCPUNotpaidSurplusCreditUsage().toString());
            valueList.add(valueBo);
            metricResultBo.setValues(valueList);
            valueMap.put("CPUNotpaidSurplusCreditUsage", metricResultBo);
        }
    }
}

