/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.service.aliyunpublic;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancePerformanceRequest;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancePerformanceResponse;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorRdsMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRdsMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRdsMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricResultBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.McmpMonitorGetResourceDetailIntf;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailReqBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorPublicAliyunRdsMetricDataIntfImpl")
public class McmpMonitorPublicAliyunRdsMetricDataIntfImpl
implements McmpMonitorRdsMetricDataIntf {
    private static final Logger log = LoggerFactory.getLogger(McmpMonitorPublicAliyunRdsMetricDataIntfImpl.class);
    @Autowired
    private McmpMonitorGetResourceDetailIntf mcmpMonitorGetResourceDetailIntf;

    @Override
    public McmpMonitorRdsMetricDataIntfRspBO getRdsMetricData(McmpMonitorRdsMetricDataIntfReqBO reqBo) {
        McmpMonitorRdsMetricDataIntfRspBO rspBo = new McmpMonitorRdsMetricDataIntfRspBO();
        String instanceId = reqBo.getInstanceId();
        McmpMonitorgetResourceDetailReqBO resourceDetailReqBo = new McmpMonitorgetResourceDetailReqBO();
        resourceDetailReqBo.setInstanceId(instanceId);
        resourceDetailReqBo.setPlatformId(reqBo.getPlatformId());
        McmpMonitorgetResourceDetailRspBO resourceDetailRspBo = this.mcmpMonitorGetResourceDetailIntf.getResourceDetail(resourceDetailReqBo);
        if (!"0000".equals(resourceDetailRspBo.getRespCode())) {
            throw new McmpBusinessException("8888", "\u67e5\u8be2\u8d44\u6e90\u8be6\u60c5\u5931\u8d25");
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)resourceDetailRspBo.getRegionId(), (String)resourceDetailRspBo.getAccessKeyId(), (String)resourceDetailRspBo.getAccessKeySecret());
        DefaultAcsClient iAcsClient = new DefaultAcsClient((IClientProfile)profile);
        DescribeDBInstancePerformanceRequest request = new DescribeDBInstancePerformanceRequest();
        request.setDBInstanceId(instanceId);
        request.setKey(reqBo.getPerformanceKeys());
        long currentTimeMillis = System.currentTimeMillis();
        if (!StringUtils.hasText((String)reqBo.getStartTime())) {
            reqBo.setStartTime(String.valueOf(currentTimeMillis - 60000L));
        }
        request.setStartTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'").format(new Date(Long.valueOf(reqBo.getStartTime()))));
        if (!StringUtils.hasText((String)reqBo.getEndTime())) {
            reqBo.setEndTime(String.valueOf(currentTimeMillis));
        }
        request.setEndTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'").format(new Date(Long.valueOf(reqBo.getEndTime()))));
        try {
            log.debug("\u8c03\u7528\u516c\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            DescribeDBInstancePerformanceResponse response = (DescribeDBInstancePerformanceResponse)iAcsClient.getAcsResponse((AcsRequest)request);
            log.debug("\u8c03\u7528\u516c\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)response));
            ArrayList<MonitorMetricDataBO> metricDataList = new ArrayList<MonitorMetricDataBO>();
            MonitorMetricDataBO metricDataBo = new MonitorMetricDataBO();
            metricDataBo.setInstanceId(response.getDBInstanceId());
            metricDataBo.setExp1(response.getEngine());
            ArrayList<MonitorMetricResultBO> metricResultList = new ArrayList<MonitorMetricResultBO>();
            response.getPerformanceKeys().forEach(data -> {
                MonitorMetricResultBO metricResultBo = this.setMetricValue((DescribeDBInstancePerformanceResponse.PerformanceKey)data);
                metricResultList.add(metricResultBo);
            });
            metricDataBo.setMetric(metricResultList);
            metricDataList.add(metricDataBo);
            rspBo.setData(metricDataList);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        catch (ClientException e) {
            log.error("\u8c03\u7528\u516c\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            rspBo.setErrCode(e.getErrCode());
            rspBo.setErrMsg(e.getErrMsg());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u963f\u91cc\u516c\u6709\u4e91RDS\u76d1\u63a7\u6570\u636e\u5f02\u5e38");
            return rspBo;
        }
    }

    private MonitorMetricResultBO setMetricValue(DescribeDBInstancePerformanceResponse.PerformanceKey data) {
        MonitorMetricResultBO metricResultBo = new MonitorMetricResultBO();
        metricResultBo.setName(data.getKey());
        ArrayList<MonitorMetricValueBO> valueList = new ArrayList<MonitorMetricValueBO>();
        data.getValues().forEach(dataValue -> {
            MonitorMetricValueBO valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp(dataValue.getDate());
            valueBo.setVal(dataValue.getValue());
            HashMap<String, Object> extMap = new HashMap<String, Object>(4);
            extMap.put("unit", data.getUnit());
            extMap.put("valueFormat", data.getValueFormat());
            valueBo.setExt(extMap);
            valueList.add(valueBo);
        });
        metricResultBo.setValues(valueList);
        return metricResultBo;
    }
}

