/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.service.aliyunpublic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.r_kvstore.model.v20150101.DescribeHistoryMonitorValuesRequest;
import com.aliyuncs.r_kvstore.model.v20150101.DescribeHistoryMonitorValuesResponse;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorRedisMetricDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRedisMetricDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorRedisMetricDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricResultBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.McmpMonitorGetResourceDetailIntf;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailReqBO;
import com.tydic.mcmp.monitor.intf.api.mcmp.bo.McmpMonitorgetResourceDetailRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mcmpMonitorPublicAliyunRedisMetricDataIntfImpl")
public class McmpMonitorPublicAliyunRedisMetricDataIntfImpl
implements McmpMonitorRedisMetricDataIntf {
    private static final Logger log = LoggerFactory.getLogger(McmpMonitorPublicAliyunRedisMetricDataIntfImpl.class);
    @Autowired
    private McmpMonitorGetResourceDetailIntf mcmpMonitorGetResourceDetailIntf;

    @Override
    public McmpMonitorRedisMetricDataIntfRspBO getRedisMetricData(McmpMonitorRedisMetricDataIntfReqBO reqBo) {
        McmpMonitorRedisMetricDataIntfRspBO rspBo = new McmpMonitorRedisMetricDataIntfRspBO();
        String instanceId = reqBo.getInstanceId();
        McmpMonitorgetResourceDetailReqBO resourceDetailReqBo = new McmpMonitorgetResourceDetailReqBO();
        resourceDetailReqBo.setInstanceId(instanceId);
        resourceDetailReqBo.setPlatformId(reqBo.getPlatformId());
        McmpMonitorgetResourceDetailRspBO resourceDetailRspBo = this.mcmpMonitorGetResourceDetailIntf.getResourceDetail(resourceDetailReqBo);
        if (!"0000".equals(resourceDetailRspBo.getRespCode())) {
            throw new McmpBusinessException("8888", "\u67e5\u8be2\u8d44\u6e90\u8be6\u60c5\u5931\u8d25");
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)resourceDetailRspBo.getRegionId(), (String)resourceDetailRspBo.getAccessKeyId(), (String)resourceDetailRspBo.getAccessKeySecret());
        DefaultAcsClient iAcsClient = new DefaultAcsClient((IClientProfile)profile);
        DescribeHistoryMonitorValuesRequest request = new DescribeHistoryMonitorValuesRequest();
        request.setInstanceId(instanceId);
        request.setMonitorKeys(reqBo.getMonitorKeys());
        request.setIntervalForHistory(reqBo.getIntervalForHistory());
        long currentTimeMillis = System.currentTimeMillis();
        if (!StringUtils.hasText((String)reqBo.getStartTime())) {
            reqBo.setStartTime(String.valueOf(currentTimeMillis - 60000L));
        }
        request.setStartTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date(Long.valueOf(reqBo.getStartTime()))));
        if (!StringUtils.hasText((String)reqBo.getEndTime())) {
            reqBo.setEndTime(String.valueOf(currentTimeMillis));
        }
        request.setEndTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date(Long.valueOf(reqBo.getEndTime()))));
        try {
            log.debug("\u8c03\u7528\u516c\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u4f20\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            DescribeHistoryMonitorValuesResponse response = (DescribeHistoryMonitorValuesResponse)iAcsClient.getAcsResponse((AcsRequest)request);
            log.debug("\u8c03\u7528\u516c\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)response));
            ArrayList<MonitorMetricDataBO> metricDataList = new ArrayList<MonitorMetricDataBO>();
            MonitorMetricDataBO metricDataBo = new MonitorMetricDataBO();
            metricDataBo.setInstanceId(instanceId);
            HashMap<String, Map<String, Object>> timeMap = new HashMap<String, Map<String, Object>>(16);
            JSONObject monitorHistory = JSON.parseObject((String)response.getMonitorHistory());
            if (null != monitorHistory) {
                Map monitorHistoryInnerMap = monitorHistory.getInnerMap();
                monitorHistoryInnerMap.forEach((key, value) -> {
                    Map valueMap = JSON.parseObject((String)value.toString()).getInnerMap();
                    timeMap.put((String)key, valueMap);
                });
                Map<String, Map<String, Object>> resultMap = this.transResultMap(timeMap);
                ArrayList<MonitorMetricResultBO> metricResultList = new ArrayList<MonitorMetricResultBO>();
                resultMap.forEach((key, value) -> {
                    MonitorMetricResultBO metricResultBo = this.setMetricValue((String)key, (Map<String, Object>)value);
                    metricResultList.add(metricResultBo);
                });
                metricDataBo.setMetric(metricResultList);
                metricDataList.add(metricDataBo);
            }
            rspBo.setData(metricDataList);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        catch (ClientException e) {
            log.error("\u8c03\u7528\u516c\u6709\u963f\u91cc\u4e91\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            rspBo.setErrCode(e.getErrCode());
            rspBo.setErrMsg(e.getErrMsg());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u963f\u91cc\u516c\u6709\u4e91REDIS\u76d1\u63a7\u6570\u636e\u5f02\u5e38");
            return rspBo;
        }
    }

    private Map<String, Map<String, Object>> transResultMap(Map<String, Map<String, Object>> timeMap) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(16);
        HashSet monitorItemSet = new HashSet();
        timeMap.values().forEach(map -> monitorItemSet.addAll(map.keySet()));
        monitorItemSet.forEach(item -> {
            Map cfr_ignored_0 = resultMap.put((String)item, new HashMap());
        });
        timeMap.forEach((time, itemMap) -> resultMap.forEach((item, obj) -> {
            if (itemMap.containsKey(item)) {
                ((Map)resultMap.get(item)).put(time, itemMap.get(item));
            }
        }));
        return resultMap;
    }

    private MonitorMetricResultBO setMetricValue(String key, Map<String, Object> value) {
        MonitorMetricResultBO metricResultBo = new MonitorMetricResultBO();
        metricResultBo.setName(key);
        ArrayList<MonitorMetricValueBO> valueList = new ArrayList<MonitorMetricValueBO>();
        value.forEach((time, val) -> {
            MonitorMetricValueBO valueBo = new MonitorMetricValueBO();
            valueBo.setTimestamp((String)time);
            valueBo.setVal(val.toString());
            valueList.add(valueBo);
        });
        metricResultBo.setValues(valueList);
        return metricResultBo;
    }
}

