/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.service.vmware;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.mcmp.monitor.intf.api.McmpMonitorCloudMetricHistoryDataIntf;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricHistoryDataIntfReqBO;
import com.tydic.mcmp.monitor.intf.api.bo.McmpMonitorCloudMetricHistoryDataIntfRspBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricDataBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricResultBO;
import com.tydic.mcmp.monitor.intf.api.common.bo.MonitorMetricValueBO;
import com.tydic.mcmp.monitor.intf.utils.MonitorHttpUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="mcmpMonitorVmwareCloudMetricHistoryDataIntfImpl")
public class McmpMonitorVmwareCloudMetricHistoryDataIntfImpl
implements McmpMonitorCloudMetricHistoryDataIntf {
    private static final Logger log = LoggerFactory.getLogger(McmpMonitorVmwareCloudMetricHistoryDataIntfImpl.class);
    @Value(value="${vmUrl}")
    private String vmUrl;

    @Override
    public McmpMonitorCloudMetricHistoryDataIntfRspBO getMetricHistoryData(McmpMonitorCloudMetricHistoryDataIntfReqBO reqBo) {
        McmpMonitorCloudMetricHistoryDataIntfRspBO rspBo = new McmpMonitorCloudMetricHistoryDataIntfRspBO();
        String instanceId = reqBo.getInstanceId();
        String params = "?hostname=" + instanceId + "&moniter=" + reqBo.getMetricName() + "&mpo=" + reqBo.getLength() + "&st=" + reqBo.getStartTime() + "&et=" + reqBo.getEndTime() + "&period=" + reqBo.getPeriod();
        String resultJson = MonitorHttpUtil.doGet(this.vmUrl + params);
        JSONObject jsonObject = JSONObject.parseObject((String)resultJson, (Feature[])new Feature[]{Feature.OrderedField});
        if (!"0000".equals(jsonObject.get((Object)"respCode"))) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2Vmware\u76d1\u63a7\u5386\u53f2\u4fe1\u606f\u5f02\u5e38");
            return rspBo;
        }
        ArrayList<MonitorMetricDataBO> metricDataList = new ArrayList<MonitorMetricDataBO>();
        JSONArray jsonArray = JSON.parseArray((String)jsonObject.get((Object)"data").toString());
        MonitorMetricDataBO metricDataBo = new MonitorMetricDataBO();
        metricDataBo.setInstanceId(instanceId);
        this.setMetricValue(metricDataBo, jsonArray, reqBo);
        metricDataList.add(metricDataBo);
        rspBo.setData(metricDataList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void setMetricValue(MonitorMetricDataBO metricDataBo, JSONArray jsonArray, McmpMonitorCloudMetricHistoryDataIntfReqBO reqBo) {
        if (!CollectionUtils.isEmpty((Collection)jsonArray) && !CollectionUtils.isEmpty((Collection)(jsonArray = jsonArray.getJSONObject(0).getJSONArray("metric")))) {
            jsonArray = jsonArray.getJSONObject(0).getJSONArray("values");
        }
        ArrayList<MonitorMetricResultBO> metricResultList = new ArrayList<MonitorMetricResultBO>();
        MonitorMetricResultBO metricResultBo = new MonitorMetricResultBO();
        metricResultBo.setName(reqBo.getMetricName());
        ArrayList<MonitorMetricValueBO> metricValueList = new ArrayList<MonitorMetricValueBO>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object val;
            MonitorMetricValueBO metricValueBo = new MonitorMetricValueBO();
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object timestamp = jsonObject.get((Object)"timestamp");
            if (null != timestamp) {
                metricValueBo.setTimestamp(timestamp.toString());
            }
            if (null != (val = jsonObject.get((Object)"val"))) {
                metricValueBo.setVal(val.toString());
            }
            metricValueList.add(metricValueBo);
        }
        metricResultBo.setValues(metricValueList);
        metricResultList.add(metricResultBo);
        metricDataBo.setMetric(metricResultList);
    }
}

