/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class MonitorHttpsUtil {
    private static HttpsURLConnection gethttpsurlconnection(String uri, String method) {
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        SSLSocketFactory ssf = null;
        if (ctx != null) {
            ssf = ctx.getSocketFactory();
        }
        URL url = null;
        HttpsURLConnection httpsConn = null;
        try {
            url = new URL(uri);
            httpsConn = (HttpsURLConnection)url.openConnection();
            if (ssf != null) {
                httpsConn.setSSLSocketFactory(ssf);
            }
            httpsConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            httpsConn.setRequestProperty("Authorization", "username");
            httpsConn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            httpsConn.setHostnameVerifier((arg0, arg1) -> true);
            httpsConn.setRequestMethod(method);
            httpsConn.setDoInput(true);
            httpsConn.setDoOutput(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpsConn;
    }

    private static String getStringFromStream(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] kb = new byte[1024];
        try {
            int len;
            while ((len = is.read(kb)) != -1) {
                baos.write(kb, 0, len);
            }
            byte[] bytes = baos.toByteArray();
            baos.close();
            is.close();
            return new String(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static void setBytesToStream(OutputStream os, byte[] bytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] kb = new byte[1024];
        try {
            int len;
            while ((len = bais.read(kb)) != -1) {
                os.write(kb, 0, len);
            }
            os.flush();
            os.close();
            bais.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String doGet(String uri) {
        try {
            HttpsURLConnection httpsConn = MonitorHttpsUtil.gethttpsurlconnection(uri, "GET");
            return MonitorHttpsUtil.getStringFromStream(httpsConn.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String doPost(String uri, String data) {
        try {
            HttpsURLConnection httpsConn = MonitorHttpsUtil.gethttpsurlconnection(uri, "POST");
            MonitorHttpsUtil.setBytesToStream(httpsConn.getOutputStream(), data.getBytes());
            return MonitorHttpsUtil.getStringFromStream(httpsConn.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static final class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

