/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.utils;

import com.aliyun.asapi.ASClient;
import com.aliyun.asapi.Cloud;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.Signer;
import com.aliyuncs.auth.StaticCredentialsProvider;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.transform.UnmarshallerContext;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrivateAcsClient
extends DefaultAcsClient {
    private String accessKeySecret;
    private Cloud cloud;
    private String endPonit;
    private URI uri;
    private Map<String, String> requestParams = new HashMap<String, String>();
    private Map<String, String> headParams;

    public PrivateAcsClient(DefaultProfile profile, Cloud cloud, URI uri, Map<String, String> headmap) {
        super((IClientProfile)profile);
        this.cloud = cloud;
        this.uri = uri;
        this.endPonit = this.uri.getHost();
        this.endPonit = this.endPonit + (this.uri.getPort() > 0 ? ":" + this.uri.getPort() : "");
        this.endPonit = this.endPonit + (this.uri.getPath() != null ? this.uri.getPath() : "");
        this.endPonit = this.endPonit + (this.uri.getQuery() != null ? "?" + this.uri.getQuery() : "");
        this.headParams = headmap;
        this.accessKeySecret = profile.getCredential().getAccessSecret();
    }

    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ServerException, ClientException {
        String region = this.getProfile().getRegionId();
        if (null == request.getSysRegionId()) {
            request.setSysRegionId(region);
        }
        AlibabaCloudCredentials credentials = new StaticCredentialsProvider((IClientProfile)this.getProfile()).getCredentials();
        Signer signer = Signer.getSigner((AlibabaCloudCredentials)credentials);
        ProductDomain domain = new ProductDomain(request.getSysProduct(), this.endPonit);
        if (request.getSysProtocol() == null) {
            request.setSysProtocol(this.getProfile().getHttpClientConfig().getProtocolType());
        }
        try {
            HttpRequest httpRequest = request.signRequest(signer, credentials, this.getProfile().getFormat(), domain);
            ASClient client = new ASClient(this.cloud);
            for (Map.Entry<String, String> entry : this.headParams.entrySet()) {
                client.addHeader(entry.getKey(), entry.getValue());
            }
            String url = this.percentDecode(request.getSysUrl());
            Map<String, String> aliurl = this.urlToMap(url);
            aliurl.putAll(this.requestParams);
            String stringContent = client.doPost(this.uri.toString(), aliurl);
            FormatType format = FormatType.JSON;
            Reader reader = ReaderFactory.createInstance((FormatType)format);
            UnmarshallerContext context = new UnmarshallerContext();
            AcsResponse response = null;
            if (stringContent == null) {
                throw new ClientException("SDK.InvalidServerResponse", "Failed to parse the response. The request was succeeded, but the server returned an empty HTTP body.");
            }
            Class clasz = request.getResponseClass();
            try {
                response = (AcsResponse)clasz.newInstance();
            }
            catch (Exception e) {
                throw new ClientException("SDK.InvalidResponseClass", "Unable to allocate " + request.getResponseClass().getName() + " class");
            }
            String responseEndpoint = clasz.getName().substring(clasz.getName().lastIndexOf(".") + 1);
            if (response.checkShowJsonItemName()) {
                context.setResponseMap(reader.read(stringContent, responseEndpoint));
            } else {
                context.setResponseMap(reader.readForHideArrayItem(stringContent, responseEndpoint));
            }
            response.getInstance(context);
            return (T)response;
        }
        catch (Exception e1) {
            throw new ServerException("9999", "SDK.PrivateAcsClient.readResponse Error" + region);
        }
    }

    private String percentDecode(String value) throws UnsupportedEncodingException {
        String decodeali = value.replace("%20", "+").replace("%2A", "*").replace("~", "%7E");
        String urldecoder = URLDecoder.decode(decodeali, "UTF-8");
        return urldecoder;
    }

    private Map<String, String> urlToMap(String url) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(".*\\?(.*)");
        Matcher matcher = pattern.matcher(url);
        matcher.find();
        String[] params = matcher.group(1).split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] p = params[i].split("=");
            if (p.length != 2 || p[0].equals("Signature") || p[0].equals("SignatureNonce")) continue;
            requestParams.put(p[0], p[1]);
            if (!p[0].equals("ServiceCode")) continue;
            requestParams.put("Product", p[1]);
        }
        requestParams.put("AccessKeySecret", this.accessKeySecret);
        return requestParams;
    }
}

