/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.monitor.intf.utils;

import com.aliyun.asapi.Cloud;
import com.aliyuncs.profile.DefaultProfile;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.monitor.intf.utils.PrivateAcsClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PrivateAcsClientUtil {
    private static final Logger log = LoggerFactory.getLogger(PrivateAcsClientUtil.class);
    @Value(value="${proxy_host}")
    private String proxyHost;
    @Value(value="${proxy_port}")
    private String proxyPort;
    @Value(value="${endpoint}")
    private String endpoint;

    public PrivateAcsClient getInstance(DefaultProfile profile, String regionId, String instanceId, String proxyHost, String proxyPort, String endpoint) {
        URI uri;
        Cloud cloud = new Cloud();
        cloud.setConfig("proxy_host", StringUtils.hasText((String)proxyHost) ? proxyHost : this.proxyHost);
        cloud.setConfig("proxy_port", StringUtils.hasText((String)proxyPort) ? proxyPort : this.proxyPort);
        try {
            uri = StringUtils.hasText((String)endpoint) ? new URI(endpoint) : new URI(this.endpoint);
        }
        catch (URISyntaxException e) {
            log.error("\u963f\u91cc\u79c1\u6709\u4e91\u5ba2\u6237\u7aef\u751f\u6210URI\u5f02\u5e38", (Throwable)e);
            throw new McmpBusinessException("8888", "\u521b\u5efaURI\u5f02\u5e38");
        }
        HashMap<String, String> headmap = new HashMap<String, String>();
        headmap.put("x-acs-organizationid", "9");
        headmap.put("x-acs-resourcegroupid", "");
        headmap.put("x-acs-regionid", regionId);
        headmap.put("x-acs-instanceid", instanceId);
        return new PrivateAcsClient(profile, cloud, uri, headmap);
    }
}

