/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.ability.api.bo.RsAliDbSeriesQueryAbilityRspSeriesBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliDbSeriesQueryAbilityRspStorageBo;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsAliDbSeriesQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsAliDbSeriesQueryBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsAliDbSeriesQueryBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoAliDbSpecMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoAliDbSpecPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsAliDbSeriesQueryBusiService")
public class RsAliDbSeriesQueryBusiServiceImpl
implements RsAliDbSeriesQueryBusiService {
    private final Logger LOOGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoAliDbSpecMapper rsInfoAliDbSpecMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public RsAliDbSeriesQueryBusiRspBo querySeries(RsAliDbSeriesQueryBusiReqBo reqBo) {
        this.LOOGER.info("\u963f\u91cc\u6570\u636e\u7cfb\u5217/\u5b58\u50a8\u7c7b\u578b\u67e5\u8be2 busi\u670d\u52a1\uff1a" + reqBo);
        RsAliDbSeriesQueryBusiRspBo retBo = new RsAliDbSeriesQueryBusiRspBo();
        ArrayList<RsAliDbSeriesQueryAbilityRspSeriesBo> series = new ArrayList<RsAliDbSeriesQueryAbilityRspSeriesBo>();
        retBo.setSeries(series);
        RsInfoAliDbSpecPo reqPo = new RsInfoAliDbSpecPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List<RsInfoAliDbSpecPo> specPos = this.rsInfoAliDbSpecMapper.selectByCondition(reqPo);
        if (CollectionUtils.isEmpty(specPos)) {
            this.LOOGER.error("\u67e5\u8be2\u5e73\u53f0\uff08" + reqBo.getPlatformId() + "\uff09\u6570\u636e\u7cfb\u5217/\u5b58\u50a8\u7c7b\u578b\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u67e5\u8be2\u5e73\u53f0\uff08" + reqBo.getPlatformId() + "\uff09\u6570\u636e\u7cfb\u5217/\u5b58\u50a8\u7c7b\u578b\u4e3a\u7a7a");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        HashSet<RsAliDbSeriesQueryAbilityRspSeriesBo> seriesSet = new HashSet<RsAliDbSeriesQueryAbilityRspSeriesBo>(16);
        for (RsInfoAliDbSpecPo po : specPos) {
            RsAliDbSeriesQueryAbilityRspSeriesBo seriesBo = new RsAliDbSeriesQueryAbilityRspSeriesBo();
            seriesBo.setSeries(po.getSeries());
            seriesBo.setSeriesName(dicMap.get("RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES").get(po.getSeries() + ""));
            seriesSet.add(seriesBo);
        }
        for (RsAliDbSeriesQueryAbilityRspSeriesBo seriesBo : seriesSet) {
            HashSet<RsAliDbSeriesQueryAbilityRspStorageBo> storageBos = new HashSet<RsAliDbSeriesQueryAbilityRspStorageBo>(16);
            for (RsInfoAliDbSpecPo po : specPos) {
                if (!po.getSeries().equals(seriesBo.getSeries())) continue;
                RsAliDbSeriesQueryAbilityRspStorageBo storageBo = new RsAliDbSeriesQueryAbilityRspStorageBo();
                storageBo.setStorageType(po.getStorageType());
                storageBo.setStorageTypeName(dicMap.get("RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE").get(po.getStorageType() + ""));
                storageBos.add(storageBo);
            }
            seriesBo.setStorageBos(new ArrayList(storageBos));
            series.add(seriesBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES");
        codes.add("RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE");
        RsDicMapQueryAtomReqBo atomReqBo = new RsDicMapQueryAtomReqBo();
        for (String code : codes) {
            atomReqBo.setType(code);
            RsDicMapQueryAtomRspBo atomRetBo = this.rsDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(code, atomRetBo.getDicMap());
        }
        return dicMap;
    }
}

