/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeDisksService;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerRunInstancesService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpAliEcsRunInstancesReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeDisksBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeDisksReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeDisksRspBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerRunInstancesReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerRunInstancesRspBO;
import com.tydic.mcmp.resource.ability.api.bo.RsHostInstanceCreateAbilityReqHdBo;
import com.tydic.mcmp.resource.ability.api.bo.RsHostInstanceCreateAbilityReqSecurityGroupBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsAliHostInstanceCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsAliHostInstanceCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsAliHostInstanceCreateBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RsAliHostInstanceCreateBusiServiceImpl
implements RsAliHostInstanceCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsAliHostInstanceCreateBusiServiceImpl.class);
    @Autowired
    private McmpCloudSerRunInstancesService mcmpCloudSerRunInstancesService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpCloudSerDescribeDisksService mcmpCloudSerDescribeDisksService;

    public RsAliHostInstanceCreateBusiRspBo aliHostInstanceCreate(RsAliHostInstanceCreateBusiReqBo busiReqBo) {
        RsAliHostInstanceCreateBusiRspBo busiRspBo = new RsAliHostInstanceCreateBusiRspBo();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        McmpCloudSerRunInstancesRspBO mcmpCloudSerRunInstancesRspBO = this.invokeExternalInfc(busiReqBo, atomRspBo);
        this.invokeDescribeDisks(mcmpCloudSerRunInstancesRspBO.getInstanceIdSets(), busiReqBo, atomRspBo);
        busiReqBo.setInstanceIdSets(mcmpCloudSerRunInstancesRspBO.getInstanceIdSets());
        busiReqBo.setTradePrice(mcmpCloudSerRunInstancesRspBO.getTradePrice());
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u963f\u91ccEcs\u5b9e\u4f8b\u521b\u5efa\u6210\u529f");
        return busiRspBo;
    }

    private void invokeDescribeDisks(List<String> instanceIdSets, RsAliHostInstanceCreateBusiReqBo busiReqBo, RsQueryAliParamAtomRspBo atomRspBo) {
        HashMap instanceIdDataHdMap = new HashMap();
        for (String instanceId : instanceIdSets) {
            McmpCloudSerDescribeDisksReqBO mcmpCloudSerDescribeDisksReqBO = new McmpCloudSerDescribeDisksReqBO();
            mcmpCloudSerDescribeDisksReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
            mcmpCloudSerDescribeDisksReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
            mcmpCloudSerDescribeDisksReqBO.setEndpointPriv(atomRspBo.getEndpoint());
            mcmpCloudSerDescribeDisksReqBO.setProxyHost(atomRspBo.getProxyHost());
            mcmpCloudSerDescribeDisksReqBO.setProxyPort(atomRspBo.getProxyPort());
            mcmpCloudSerDescribeDisksReqBO.setRegion(busiReqBo.getRegionId());
            mcmpCloudSerDescribeDisksReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
            mcmpCloudSerDescribeDisksReqBO.setInstanceId(instanceId);
            log.info("\u4e91\u4e3b\u673a\u4e91\u76d8\u5217\u8868\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDescribeDisksReqBO));
            McmpCloudSerDescribeDisksRspBO mcmpCloudSerDescribeDisksRspBO = this.mcmpCloudSerDescribeDisksService.describeDisks(mcmpCloudSerDescribeDisksReqBO);
            log.info("\u4e91\u4e3b\u673a\u4e91\u76d8\u5217\u8868\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDescribeDisksRspBO));
            if (!"0000".equals(mcmpCloudSerDescribeDisksRspBO.getRespCode())) {
                throw new McmpBusinessException(mcmpCloudSerDescribeDisksRspBO.getRespCode(), mcmpCloudSerDescribeDisksRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)mcmpCloudSerDescribeDisksRspBO.getRows())) continue;
            ArrayList<RsHostInstanceCreateAbilityReqHdBo> rsHostInstanceCreateAbilityReqHdBos = new ArrayList<RsHostInstanceCreateAbilityReqHdBo>();
            for (McmpCloudSerDescribeDisksBO mcmpCloudSerDescribeDisksBO : mcmpCloudSerDescribeDisksRspBO.getRows()) {
                RsHostInstanceCreateAbilityReqHdBo rsHostInstanceCreateAbilityReqHdBo = new RsHostInstanceCreateAbilityReqHdBo();
                rsHostInstanceCreateAbilityReqHdBo.setHdDesc(mcmpCloudSerDescribeDisksBO.getDescription());
                rsHostInstanceCreateAbilityReqHdBo.setHdName(mcmpCloudSerDescribeDisksBO.getDiskName());
                rsHostInstanceCreateAbilityReqHdBo.setHdPayType(RsInterfaceUtil.convertAliDiskChargeTypeHdPayType(mcmpCloudSerDescribeDisksBO.getDiskChargeType()));
                rsHostInstanceCreateAbilityReqHdBo.setHdType(RsInterfaceUtil.convertAliDiskCategoryHdType(mcmpCloudSerDescribeDisksBO.getCategory()));
                rsHostInstanceCreateAbilityReqHdBo.setHdProperty(RsInterfaceUtil.convertAliDiskTypeHdProperty(mcmpCloudSerDescribeDisksBO.getType()));
                rsHostInstanceCreateAbilityReqHdBo.setHdSize(mcmpCloudSerDescribeDisksBO.getSize());
                rsHostInstanceCreateAbilityReqHdBo.setInstanceId(mcmpCloudSerDescribeDisksBO.getDiskId());
                rsHostInstanceCreateAbilityReqHdBos.add(rsHostInstanceCreateAbilityReqHdBo);
            }
            instanceIdDataHdMap.put(instanceId, rsHostInstanceCreateAbilityReqHdBos);
        }
        busiReqBo.setInstanceIdDataHdMap(instanceIdDataHdMap);
    }

    private McmpCloudSerRunInstancesRspBO invokeExternalInfc(RsAliHostInstanceCreateBusiReqBo busiReqBo, RsQueryAliParamAtomRspBo atomRspBo) {
        McmpCloudSerRunInstancesReqBO mcmpCloudSerRunInstancesReqBO = new McmpCloudSerRunInstancesReqBO();
        McmpAliEcsRunInstancesReqBO mcmpAliEcsRunInstancesReqBO = new McmpAliEcsRunInstancesReqBO();
        mcmpCloudSerRunInstancesReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpCloudSerRunInstancesReqBO.setMcmpAliEcsRunInstancesReqBO(mcmpAliEcsRunInstancesReqBO);
        mcmpCloudSerRunInstancesReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpCloudSerRunInstancesReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpCloudSerRunInstancesReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpCloudSerRunInstancesReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpCloudSerRunInstancesReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpAliEcsRunInstancesReqBO.setRegionId(busiReqBo.getRegionId());
        mcmpAliEcsRunInstancesReqBO.setImageId(busiReqBo.getImageId());
        mcmpAliEcsRunInstancesReqBO.setInstanceType(busiReqBo.getInstanceType());
        ArrayList<String> securityGroupIdss = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)busiReqBo.getSecurityGroups())) {
            if (1L == busiReqBo.getPlatformId()) {
                for (RsHostInstanceCreateAbilityReqSecurityGroupBo groupBo : busiReqBo.getSecurityGroups()) {
                    securityGroupIdss.add(groupBo.getInstanceId());
                }
                mcmpAliEcsRunInstancesReqBO.setSecurityGroupIdss(securityGroupIdss);
            } else if (2L == busiReqBo.getPlatformId()) {
                mcmpAliEcsRunInstancesReqBO.setSecurityGroupId(((RsHostInstanceCreateAbilityReqSecurityGroupBo)busiReqBo.getSecurityGroups().get(0)).getInstanceId());
            }
        }
        mcmpAliEcsRunInstancesReqBO.setVswitchId(busiReqBo.getInterchange());
        mcmpAliEcsRunInstancesReqBO.setHostName(busiReqBo.getHostName());
        mcmpAliEcsRunInstancesReqBO.setPassword(busiReqBo.getInitRootPwd());
        mcmpAliEcsRunInstancesReqBO.setZoneId(busiReqBo.getZoneId());
        mcmpAliEcsRunInstancesReqBO.setInternetChargeType(RsInterfaceUtil.convertAliInternetChargeType(busiReqBo.getBwBillType()));
        if (!CollectionUtils.isEmpty((Collection)busiReqBo.getDataHds())) {
            ArrayList<McmpAliEcsRunInstancesReqBO.DataDisk> dataDisks = new ArrayList<McmpAliEcsRunInstancesReqBO.DataDisk>();
            for (RsHostInstanceCreateAbilityReqHdBo hdBo : busiReqBo.getDataHds()) {
                if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_SYS.equals(hdBo.getHdProperty())) {
                    mcmpAliEcsRunInstancesReqBO.setSystemDiskSize(hdBo.getHdSize().toString());
                    mcmpAliEcsRunInstancesReqBO.setSystemDiskCategory(RsInterfaceUtil.convertAliHdType(hdBo.getHdType()));
                    mcmpAliEcsRunInstancesReqBO.setSystemDiskDiskName(hdBo.getHdName());
                    continue;
                }
                McmpAliEcsRunInstancesReqBO.DataDisk dataDiskBo = new McmpAliEcsRunInstancesReqBO.DataDisk();
                dataDiskBo.setSize(hdBo.getHdSize());
                dataDiskBo.setCategory(RsInterfaceUtil.convertAliHdType(hdBo.getHdType()));
                dataDiskBo.setDiskName(hdBo.getHdName());
                dataDisks.add(dataDiskBo);
            }
            mcmpAliEcsRunInstancesReqBO.setDataDisks(dataDisks);
        }
        mcmpAliEcsRunInstancesReqBO.setAmount(busiReqBo.getCreateNumbers());
        mcmpAliEcsRunInstancesReqBO.setPeriod(busiReqBo.getPayMonths());
        mcmpAliEcsRunInstancesReqBO.setInstanceChargeType(RsInterfaceUtil.convertAliHostPayType(busiReqBo.getPayType()));
        log.info("\u4e91\u4e3b\u673a\u5b9e\u4f8b\u6279\u91cf\u521b\u5efa\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerRunInstancesReqBO));
        McmpCloudSerRunInstancesRspBO mcmpCloudSerRunInstancesRspBO = this.mcmpCloudSerRunInstancesService.runInstances(mcmpCloudSerRunInstancesReqBO);
        log.info("\u4e91\u4e3b\u673a\u5b9e\u4f8b\u6279\u91cf\u521b\u5efa\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerRunInstancesRspBO));
        if (!"0000".equals(mcmpCloudSerRunInstancesRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpCloudSerRunInstancesRspBO.getRespCode(), mcmpCloudSerRunInstancesRspBO.getRespDesc());
        }
        return mcmpCloudSerRunInstancesRspBO;
    }
}

