/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.busi.api.RsCloudHdCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdCreateBusiRsp;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsCloudHdCreateBusiService")
public class RsCloudHdCreateBusiServiceImpl
implements RsCloudHdCreateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String RESOURCE_NAME = "\u4e91\u76d8";
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private SequenceManagement sequenceManagement;

    public RsCloudHdCreateBusiRsp hdCreate(RsCloudHdCreateBusiReqBo reqBo) {
        this.LOGGER.info("\u4e91\u76d8\u521b\u5efa Busi\u670d\u52a1\uff1a" + reqBo);
        RsCloudHdCreateBusiRsp retBo = new RsCloudHdCreateBusiRsp();
        ArrayList<Long> resourceIds = new ArrayList<Long>();
        ArrayList<RsInfoHardDiskPo> hdPos = new ArrayList<RsInfoHardDiskPo>();
        ArrayList<RsInfoResourcePo> resourcePos = new ArrayList<RsInfoResourcePo>();
        for (int size = 0; size < reqBo.getCreateNumbers(); ++size) {
            Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
            resourceIds.add(resourceId);
            RsInfoHardDiskPo hdPo = new RsInfoHardDiskPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)hdPo);
            hdPo.setHdResourceId(resourceId);
            hdPo.setHdStatus(RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_STATUS_FREE);
            hdPos.add(hdPo);
            RsInfoResourcePo resourcePo = new RsInfoResourcePo();
            BeanUtils.copyProperties((Object)reqBo, (Object)resourcePo);
            resourcePo.setResourceName("\u4e91\u76d8");
            resourcePo.setServiceId(7L);
            resourcePo.setResourceId(resourceId);
        }
        int result = this.rsInfoHardDiskMapper.insertBatch(hdPos);
        if (result < reqBo.getCreateNumbers()) {
            this.LOGGER.error("\u4e91\u76d8\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
            throw new McmpBusinessException("9000", "\u4e91\u76d8\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
        }
        result = this.rsInfoResourceMapper.insertBatch(resourcePos);
        if (result < reqBo.getCreateNumbers()) {
            this.LOGGER.error("\u8d44\u6e90\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
            throw new McmpBusinessException("9000", "\u8d44\u6e90\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
        }
        retBo.setResourceIds(resourceIds);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Long getSequenceId(String sequenceName) {
        long sequenceId;
        try {
            sequenceId = this.sequenceManagement.nextId(sequenceName);
        }
        catch (SQLException e) {
            this.LOGGER.error("\u83b7\u53d6\u4e91\u76d8\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u4e91\u76d8\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
        }
        return sequenceId;
    }
}

