/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsCloudHdPageQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdPageQueryBusiReqBo;
import com.tydic.mcmp.resource.common.bo.RsCloudHdQueryDataBo;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskQueryPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsCloudHdPageQueryBusiService")
public class RsCloudHdPageQueryBusiServiceImpl
implements RsCloudHdPageQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public McmpRspPageBo<McmpRspPageDataBo<RsCloudHdQueryDataBo>> hdListQuery(RsCloudHdPageQueryBusiReqBo reqBo) {
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo data = new McmpRspPageDataBo();
        retBo.setData((Object)data);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        RsInfoHardDiskQueryPo queryPo = new RsInfoHardDiskQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        queryPo.setHdName(reqBo.getName());
        Page<RsInfoHardDiskQueryPo> page = this.getPage(reqBo);
        List<RsInfoHardDiskQueryPo> diskPos = this.rsInfoHardDiskMapper.selectPageByQuery(queryPo, page);
        if (CollectionUtils.isEmpty(diskPos)) {
            this.LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u4e91\u76d8\u4fe1\u606f");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        ArrayList<RsCloudHdQueryDataBo> rows = new ArrayList<RsCloudHdQueryDataBo>();
        for (RsInfoHardDiskQueryPo diskPo : diskPos) {
            RsCloudHdQueryDataBo hdBo = new RsCloudHdQueryDataBo();
            BeanUtils.copyProperties((Object)diskPo, (Object)hdBo);
            hdBo.setHdStatusName(dicMap.get("RS_INFO_HARD_DISK_HD_STATUS").get(diskPo.getHdStatus().toString()));
            hdBo.setHdPayTypeName(dicMap.get("RS_INFO_HARD_DISK_HD_PAY_TYPE").get(diskPo.getHdPayType().toString()));
            hdBo.setHdPropertyName(dicMap.get("RS_INFO_HARD_DISK_HD_PROPERTY").get(diskPo.getHdProperty().toString()));
            hdBo.setHdTypeName(dicMap.get("RS_INFO_HARD_DISK_HD_TYPE").get(diskPo.getHdType().toString()));
            rows.add(hdBo);
        }
        data.setRows(rows);
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return retBo;
    }

    private Page<RsInfoHardDiskQueryPo> getPage(RsCloudHdPageQueryBusiReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("RS_INFO_HARD_DISK_HD_STATUS");
        codes.add("RS_INFO_HARD_DISK_HD_PROPERTY");
        codes.add("RS_INFO_HARD_DISK_HD_PAY_TYPE");
        codes.add("RS_INFO_HARD_DISK_HD_TYPE");
        RsDicMapQueryAtomReqBo atomReqBo = new RsDicMapQueryAtomReqBo();
        for (String code : codes) {
            atomReqBo.setType(code);
            RsDicMapQueryAtomRspBo atomRetBo = this.rsDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(code, atomRetBo.getDicMap());
        }
        return dicMap;
    }
}

