/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.ability.api.bo.RsCloudPlatformAccountParamDetailDataBo;
import com.tydic.mcmp.resource.busi.api.RsCloudPlatformAccountUpdateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudPlatformAccountUpdateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudPlatformAccountUpdateBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsRelTenementPlatformParamMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPlatformAcountPo;
import com.tydic.mcmp.resource.dao.po.RsRelTenementPlatformParamPo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="RsCloudPlatformAccountUpdateBusiService")
public class RsCloudPlatformAccountUpdateBusiServiceImpl
implements RsCloudPlatformAccountUpdateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private RsRelTenementPlatformParamMapper rsRelTenementPlatformParamMapper;

    public RsCloudPlatformAccountUpdateBusiRspBo updateAccount(RsCloudPlatformAccountUpdateBusiReqBo reqBo) {
        int result;
        Date nowTime;
        this.LOGGER.info("\u4e91\u5e73\u53f0\u8d26\u6237\u66f4\u65b0busi\u670d\u52a1\uff1a" + reqBo);
        RsCloudPlatformAccountUpdateBusiRspBo retBo = new RsCloudPlatformAccountUpdateBusiRspBo();
        String validateStr = this.validate(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error(validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        try {
            nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        }
        catch (Exception e) {
            this.LOGGER.error("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u5f02\u5e38\uff1a" + e);
            throw new McmpBusinessException("24003", "\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u5f02\u5e38\uff1a" + e);
        }
        RsInfoPlatformAcountPo accountPo = new RsInfoPlatformAcountPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)accountPo);
        accountPo.setUpdateTime(nowTime);
        try {
            result = this.rsInfoPlatformAcountMapper.updateByPrimaryKeySelective(accountPo);
        }
        catch (Exception e) {
            this.LOGGER.info("\u66f4\u65b0\u4e91\u5e73\u53f0\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u5f02\u5e38\uff1a" + e);
            throw new McmpBusinessException("24012", "\u66f4\u65b0\u4e91\u5e73\u53f0\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u5f02\u5e38\uff1a" + e);
        }
        if (result < 0) {
            this.LOGGER.error("\u66f4\u65b0\u4e91\u5e73\u53f0\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("24012", "\u66f4\u65b0\u4e91\u5e73\u53f0\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        RsRelTenementPlatformParamPo relPo = new RsRelTenementPlatformParamPo();
        relPo.setAccountId(reqBo.getAccountId());
        relPo.setTenementId(Long.valueOf(reqBo.getTenementId()));
        relPo.setPlatformId((long)reqBo.getPlatformId());
        List<RsRelTenementPlatformParamPo> paramPos = this.rsRelTenementPlatformParamMapper.selectByCondition(relPo);
        this.LOGGER.error("\u67e5\u8be2\u5230\u7684\u8d26\u6237\u53c2\u6570\u4e3a\uff1a" + paramPos);
        RsRelTenementPlatformParamPo paramPoOld = paramPos.get(0);
        try {
            result = this.rsRelTenementPlatformParamMapper.deleteByCondition(relPo);
        }
        catch (Exception e) {
            this.LOGGER.error("\u5220\u9664\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38\uff1a" + e);
            throw new McmpBusinessException("24012", "\u5220\u9664\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38\uff1a" + e);
        }
        if (result < 1) {
            this.LOGGER.error("\u5220\u9664\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("24012", "\u5220\u9664\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        this.LOGGER.info("\u5220\u9664\u5220\u9664\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u6210\u529f");
        BeanUtils.copyProperties((Object)reqBo, (Object)relPo);
        relPo.setUpdateTime(nowTime);
        relPo.setCreateOper(paramPoOld.getCreateOper());
        relPo.setCreateTime(paramPoOld.getCreateTime());
        for (RsCloudPlatformAccountParamDetailDataBo dataBo : reqBo.getParams()) {
            relPo.setParamKey(dataBo.getParamKey());
            relPo.setParamValue(dataBo.getParamValue());
            relPo.setAccounted(dataBo.getAccounted());
            try {
                result = this.rsRelTenementPlatformParamMapper.insertSelective(relPo);
            }
            catch (Exception e) {
                this.LOGGER.error("\u66f4\u65b0\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38\uff1a" + e);
                throw new McmpBusinessException("24010", "\u66f4\u65b0\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u5f02\u5e38\uff1a" + e);
            }
            if (result >= 0) continue;
            this.LOGGER.error("\u66f4\u65b0\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("24010", "\u66f4\u65b0\u79df\u6237-\u4e91\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u5173\u7cfb\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validate(RsCloudPlatformAccountUpdateBusiReqBo reqBo) {
        if (!StringUtils.isEmpty((Object)reqBo.getAccountName())) {
            RsInfoPlatformAcountPo accountPo = new RsInfoPlatformAcountPo();
            accountPo.setAccountName(reqBo.getAccountName());
            List<RsInfoPlatformAcountPo> accounts = this.rsInfoPlatformAcountMapper.selectByCondition(accountPo);
            if (!CollectionUtils.isEmpty(accounts)) {
                for (RsInfoPlatformAcountPo po : accounts) {
                    if (po.getAccountId().equals(reqBo.getAccountId())) continue;
                    return "\u6b64\u8d26\u6237\u540d\u79f0\u5df2\u88ab\u5360\u7528";
                }
            }
        }
        return null;
    }
}

