/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerCreateSnapshotService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerCreateSnapshotReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerCreateSnapshotRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsCreateHostSnapshotBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateHostSnapshotBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateHostSnapshotBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoHostSnapshotMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelHostSnapshotMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHostSnapshotPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsRelHostSnapshotPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsCreateHostSnapshotBusiServiceImpl
implements RsCreateHostSnapshotBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsCreateHostSnapshotBusiServiceImpl.class);
    @Autowired
    private RsInfoHostSnapshotMapper rsInfoHostSnapshotMapper;
    @Autowired
    private RsRelHostSnapshotMapper rsRelHostSnapshotMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private McmpCloudSerCreateSnapshotService mcmpCloudSerCreateSnapshotService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsCreateHostSnapshotBusiRspBo createHostSnapshot(RsCreateHostSnapshotBusiReqBo busiReqBo) {
        RsCreateHostSnapshotBusiRspBo busiRspBo = new RsCreateHostSnapshotBusiRspBo();
        String snapshotId = this.invokeCreateSnapshot(busiReqBo);
        Long snapshotResourceId = this.insetSnapshotInfo(busiReqBo, snapshotId);
        busiRspBo.setSnapshotResourceId(snapshotResourceId);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u5feb\u7167\u521b\u5efa\u6210\u529f");
        return busiRspBo;
    }

    private String invokeCreateSnapshot(RsCreateHostSnapshotBusiReqBo busiReqBo) {
        McmpCloudSerCreateSnapshotReqBO mcmpCloudSerCreateSnapshotReqBO = new McmpCloudSerCreateSnapshotReqBO();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        mcmpCloudSerCreateSnapshotReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpCloudSerCreateSnapshotReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpCloudSerCreateSnapshotReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpCloudSerCreateSnapshotReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpCloudSerCreateSnapshotReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpCloudSerCreateSnapshotReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpCloudSerCreateSnapshotReqBO.setDiskId(busiReqBo.getHdInstanceId());
        mcmpCloudSerCreateSnapshotReqBO.setRegion(busiReqBo.getRegion());
        log.info("\u4e91\u4e3b\u673a\u521b\u5efa\u5feb\u7167\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerCreateSnapshotReqBO));
        McmpCloudSerCreateSnapshotRspBO mcmpCloudSerCreateSnapshotRspBO = this.mcmpCloudSerCreateSnapshotService.createSnapshot(mcmpCloudSerCreateSnapshotReqBO);
        log.info("\u4e91\u4e3b\u673a\u521b\u5efa\u5feb\u7167\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerCreateSnapshotRspBO));
        if (!"0000".equals(mcmpCloudSerCreateSnapshotRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpCloudSerCreateSnapshotRspBO.getRespCode(), mcmpCloudSerCreateSnapshotRspBO.getRespDesc());
        }
        return mcmpCloudSerCreateSnapshotRspBO.getSnapshotId();
    }

    private Long insetSnapshotInfo(RsCreateHostSnapshotBusiReqBo busiReqBo, String snapshotId) {
        RsInfoResourcePo rsInfoResourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(busiReqBo.getHostResourceId());
        if (null == rsInfoResourcePo) {
            throw new McmpBusinessException("24003", "\u8d44\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RsInfoHostSnapshotPo rsInfoHostSnapshotPo = new RsInfoHostSnapshotPo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoHostSnapshotPo);
        rsInfoHostSnapshotPo.setCreateTime(new Date());
        rsInfoHostSnapshotPo.setSnapshotResourceId(this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString()));
        rsInfoHostSnapshotPo.setInstanceId(snapshotId);
        int count = this.rsInfoHostSnapshotMapper.insertSelective(rsInfoHostSnapshotPo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u4e3b\u673a\u5feb\u7167\u4fe1\u606f\u8868\u65b0\u589e\u5931\u8d25");
        }
        RsInfoResourcePo rsInfoResourcePo1 = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)rsInfoResourcePo, (Object)rsInfoResourcePo1);
        rsInfoResourcePo1.setResourceId(rsInfoHostSnapshotPo.getSnapshotResourceId());
        rsInfoResourcePo1.setCreateTime(new Date());
        rsInfoResourcePo1.setCreateOper(busiReqBo.getCreateOper());
        rsInfoResourcePo1.setServiceId(8L);
        rsInfoResourcePo1.setResourceName("\u5feb\u7167");
        rsInfoResourcePo1.setInstanceId(snapshotId);
        int count1 = this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo1);
        if (count1 != 1) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        RsRelHostSnapshotPo rsRelHostSnapshotPo = new RsRelHostSnapshotPo();
        rsRelHostSnapshotPo.setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_HOST_SNAPSHOT.toString()));
        rsRelHostSnapshotPo.setHostResourceId(busiReqBo.getHostResourceId());
        rsRelHostSnapshotPo.setSnapshotResourceId(rsInfoHostSnapshotPo.getSnapshotResourceId());
        int count2 = this.rsRelHostSnapshotMapper.insertSelective(rsRelHostSnapshotPo);
        if (count2 != 1) {
            throw new McmpBusinessException("24010", "\u5feb\u7167-\u4e3b\u673a\u5173\u7cfb\u8868\u65b0\u589e\u5931\u8d25");
        }
        return rsInfoHostSnapshotPo.getSnapshotResourceId();
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

