/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.oss.McmpOssCreateOssBucketService;
import com.tydic.mcmp.intf.api.oss.bo.McmpOssCreateOssBucketReqBO;
import com.tydic.mcmp.intf.api.oss.bo.McmpOssCreateOssBucketRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsCreateOssBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateOssBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateOssBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceObjectStorageMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceObjectStoragePo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsCreateOssBusiServiceImpl
implements RsCreateOssBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsCreateOssBusiServiceImpl.class);
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceObjectStorageMapper rsInfoResourceObjectStorageMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private McmpOssCreateOssBucketService mcmpOssCreateOssBucketService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsCreateOssBusiRspBo createOss(RsCreateOssBusiReqBo busiReqBo) {
        RsCreateOssBusiRspBo busiRspBo = new RsCreateOssBusiRspBo();
        Long resourceId = this.insertResourceInfo(busiReqBo);
        this.insertObjectStorage(busiReqBo, resourceId);
        this.invokeCreateOssBucket(busiReqBo);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u521b\u5efa\u5bf9\u8c61\u5b58\u50a8\u6210\u529f");
        return busiRspBo;
    }

    private void invokeCreateOssBucket(RsCreateOssBusiReqBo busiReqBo) {
        McmpOssCreateOssBucketReqBO mcmpOssCreateOssBucketReqBO = new McmpOssCreateOssBucketReqBO();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        mcmpOssCreateOssBucketReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpOssCreateOssBucketReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpOssCreateOssBucketReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpOssCreateOssBucketReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpOssCreateOssBucketReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpOssCreateOssBucketReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpOssCreateOssBucketReqBO.setRegion(busiReqBo.getRegionId());
        mcmpOssCreateOssBucketReqBO.setBucketName(busiReqBo.getBucketName());
        mcmpOssCreateOssBucketReqBO.setStorageClass(RsInterfaceUtil.convertAliStorageClass(busiReqBo.getOssType()));
        mcmpOssCreateOssBucketReqBO.setCannedACL(RsInterfaceUtil.convertAliCannedACL(busiReqBo.getReadAuthority()));
        log.info("\u8c03\u7528\u5bf9\u8c61\u5b58\u50a8\u521b\u5efaAPI\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpOssCreateOssBucketReqBO));
        McmpOssCreateOssBucketRspBO mcmpOssCreateOssBucketRspBO = this.mcmpOssCreateOssBucketService.createOssBucket(mcmpOssCreateOssBucketReqBO);
        log.info("\u8c03\u7528\u5bf9\u8c61\u5b58\u50a8\u521b\u5efaAPI\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpOssCreateOssBucketRspBO));
        if (!"0000".equals(mcmpOssCreateOssBucketRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpOssCreateOssBucketRspBO.getRespCode(), mcmpOssCreateOssBucketRspBO.getRespDesc());
        }
    }

    private void insertObjectStorage(RsCreateOssBusiReqBo busiReqBo, Long resourceId) {
        RsInfoResourceObjectStoragePo objectStoragePo = new RsInfoResourceObjectStoragePo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)objectStoragePo);
        objectStoragePo.setOssResourceId(resourceId);
        int count = this.rsInfoResourceObjectStorageMapper.insertSelective(objectStoragePo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u5bf9\u8c61\u5b58\u50a8\u4fe1\u606f\u8868\u65b0\u589e\u5931\u8d25");
        }
    }

    private Long insertResourceInfo(RsCreateOssBusiReqBo busiReqBo) {
        Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoResourcePo);
        rsInfoResourcePo.setResourceId(resourceId);
        rsInfoResourcePo.setServiceId(3L);
        int count = this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        return resourceId;
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

