/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.rds.McmpIntfDatabaseCreateDBInstanceService;
import com.tydic.mcmp.intf.api.rds.bo.McmpAliRdsCreateDbInstanceReqBO;
import com.tydic.mcmp.intf.api.rds.bo.McmpIntfDatabaseCreateDBInstanceReqBO;
import com.tydic.mcmp.intf.api.rds.bo.McmpIntfDatabaseCreateDBInstanceRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsDatabaseIndCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabaseIndCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabaseIndCreateBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceDatabaseMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceDatabasePo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsDatabaseIndCreateBusiService")
public class RsDatabaseIndCreateBusiServiceImpl
implements RsDatabaseIndCreateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private McmpIntfDatabaseCreateDBInstanceService mcmpIntfDatabaseCreateDBInstanceService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceDatabaseMapper rsInfoResourceDatabaseMapper;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private SequenceManagement sequenceManagement;

    public RsDatabaseIndCreateBusiRspBo createDatabaseIns(RsDatabaseIndCreateBusiReqBo reqBo) {
        this.LOGGER.info("\u6570\u636e\u5e93\u5b9e\u4f8b\u521b\u5efabusi\u670d\u52a1\uff1a" + reqBo);
        RsDatabaseIndCreateBusiRspBo retBo = new RsDatabaseIndCreateBusiRspBo();
        McmpIntfDatabaseCreateDBInstanceRspBO createDbInsRetBo = this.invokeExtInterface(reqBo);
        this.LOGGER.info("\u5916\u90e8\u63a5\u53e3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)createDbInsRetBo));
        if (!"0000".equals(createDbInsRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u63a5\u53e3\u521b\u5efa\u6570\u636e\u5e93\u5b9e\u4f8b\u5931\u8d25\uff1a" + createDbInsRetBo.getRespDesc());
            throw new McmpBusinessException("9000", "\u8c03\u7528\u63a5\u53e3\u521b\u5efa\u6570\u636e\u5e93\u5b9e\u4f8b\u5931\u8d25\uff1a" + createDbInsRetBo.getRespDesc());
        }
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        Long resourceId = this.insertDatabaseInfo(reqBo, createDbInsRetBo);
        this.insertResourceInfo(reqBo, resourceId, createDbInsRetBo, nowTime);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void insertResourceInfo(RsDatabaseIndCreateBusiReqBo reqBo, Long resourceId, McmpIntfDatabaseCreateDBInstanceRspBO createDbInsRetBo, Date nowTime) {
        RsInfoResourcePo resourcePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)resourcePo);
        resourcePo.setResourceName(createDbInsRetBo.getDBInstanceId());
        resourcePo.setResourceId(resourceId);
        resourcePo.setServiceId(2L);
        resourcePo.setInstanceId(createDbInsRetBo.getDBInstanceId());
        resourcePo.setRequestId(reqBo.getCreateOper());
        resourcePo.setCreateTime(nowTime);
        int result = this.rsInfoResourceMapper.insertSelective(resourcePo);
        if (result < 1) {
            throw new McmpBusinessException("24010", "\u5199\u8d44\u6e90\u4fe1\u606f\u8868\u5931\u8d25");
        }
    }

    private Long insertDatabaseInfo(RsDatabaseIndCreateBusiReqBo reqBo, McmpIntfDatabaseCreateDBInstanceRspBO createDbInsRetBo) {
        long resourceId;
        try {
            resourceId = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        }
        catch (SQLException e) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
        }
        RsInfoResourceDatabasePo databasePo = new RsInfoResourceDatabasePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)databasePo);
        databasePo.setResourceId(resourceId);
        databasePo.setInstanceId(createDbInsRetBo.getDBInstanceId());
        databasePo.setNetType("Internet");
        databasePo.setPublicAddress(createDbInsRetBo.getConnectionString());
        databasePo.setPort(createDbInsRetBo.getPort());
        databasePo.setInstanceMemory(reqBo.getInstanceMemory());
        int result = this.rsInfoResourceDatabaseMapper.insertSelective(databasePo);
        if (result < 1) {
            throw new McmpBusinessException("24010", "\u5199\u6570\u636e\u5e93\u4fe1\u606f\u8868\u5931\u8d25");
        }
        return resourceId;
    }

    private McmpIntfDatabaseCreateDBInstanceRspBO invokeExtInterface(RsDatabaseIndCreateBusiReqBo reqBo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        McmpIntfDatabaseCreateDBInstanceReqBO createDbInsReqBo = new McmpIntfDatabaseCreateDBInstanceReqBO();
        if (2L == reqBo.getPlatformId()) {
            createDbInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            createDbInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            createDbInsReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            createDbInsReqBo.setProxyHost(atomRetBo.getProxyHost());
            createDbInsReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            createDbInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            createDbInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            createDbInsReqBo.setRegion(reqBo.getRegionId());
        }
        createDbInsReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        McmpAliRdsCreateDbInstanceReqBO dataBo = new McmpAliRdsCreateDbInstanceReqBO();
        dataBo.setDBInstanceClass(reqBo.getInstanceSpecification());
        dataBo.setDBInstanceNetType("Internet");
        dataBo.setDBInstanceStorage(reqBo.getInstanceStorage());
        dataBo.setEngine(RsInterfaceUtil.convertAliInstanceType(reqBo.getInstanceType()));
        dataBo.setEngineVersion(reqBo.getInstanceVersion());
        dataBo.setPayType(RsInterfaceUtil.convertAliDbInsPayType(reqBo.getPayType()));
        dataBo.setSecurityIPList(reqBo.getSecurityIps());
        dataBo.setInstanceNetworkType(reqBo.getNetType());
        dataBo.setDBInstanceStorageType(RsInterfaceUtil.convertAliHdType(Integer.parseInt(reqBo.getStorageType())));
        dataBo.setCategory(RsInterfaceUtil.convertAliInstanceSeries(reqBo.getInstanceSeries()));
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_MONTH.equals(reqBo.getPayType())) {
            dataBo.setUsedTime(reqBo.getBuyTime() + "");
            dataBo.setPeriod(reqBo.getTimeUnit());
        }
        createDbInsReqBo.setMcmpAliRdsCreateDbInstanceReqBO(dataBo);
        createDbInsReqBo.setMcmpAliRdsCreateDbInstanceReqBO(dataBo);
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5165\u53c2\uff1a" + createDbInsReqBo.toString());
        return this.mcmpIntfDatabaseCreateDBInstanceService.createDBInstance(createDbInsReqBo);
    }
}

