/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsDatabasePageQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabasePageQueryBusiReqBo;
import com.tydic.mcmp.resource.common.bo.RsDatabaseQueryDataBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceDatabaseMapper;
import com.tydic.mcmp.resource.dao.po.RsDataBaseQueryPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsDatabasePageQueryBusiService")
public class RsDatabasePageQueryBusiServiceImpl
implements RsDatabasePageQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoResourceDatabaseMapper rsInfoResourceDatabaseMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public McmpRspPageBo<McmpRspPageDataBo<RsDatabaseQueryDataBo>> qryDatabase(RsDatabasePageQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u6570\u636e\u5e93\u5b9e\u4f8b\u5206\u9875\u67e5\u8be2busi\u670d\u52a1\uff1a" + reqBo);
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo data = new McmpRspPageDataBo();
        retBo.setData((Object)data);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Page<RsDataBaseQueryPo> page = this.getPage(reqBo);
        RsDataBaseQueryPo reqPo = new RsDataBaseQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List<RsDataBaseQueryPo> databaseIns = this.rsInfoResourceDatabaseMapper.selectByQuery(reqPo, page);
        if (CollectionUtils.isEmpty(databaseIns)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u5e93\u5b9e\u4f8b\u4fe1\u606f");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        ArrayList<RsDatabaseQueryDataBo> rows = new ArrayList<RsDatabaseQueryDataBo>();
        for (RsDataBaseQueryPo po : databaseIns) {
            RsDatabaseQueryDataBo dataBo = new RsDatabaseQueryDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dataBo);
            dataBo.setInstanceSeriesDesc(dicMap.get("RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES").get(po.getInstanceSeries() + ""));
            dataBo.setInstanceTypeDesc(dicMap.get("RS_INFO_RESOURCE_DATABASE_INSTANCE_TYPE").get(po.getInstanceType() + ""));
            dataBo.setPayTypeDesc(dicMap.get("RS_INFO_RESOURCE_DATABASE_PAY_TYPE").get(po.getPayType() + ""));
            dataBo.setStorageTypeDesc(dicMap.get("RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE").get(po.getStorageType() + ""));
            rows.add(dataBo);
        }
        data.setRows(rows);
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("RS_INFO_RESOURCE_DATABASE_INSTANCE_TYPE");
        pCodes.add("RS_INFO_RESOURCE_DATABASE_PAY_TYPE");
        pCodes.add("RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE");
        pCodes.add("RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES");
        RsDicMapQueryAtomReqBo atomReqBo = new RsDicMapQueryAtomReqBo();
        for (String pCode : pCodes) {
            atomReqBo.setType(pCode);
            RsDicMapQueryAtomRspBo atomRetBo = this.rsDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(pCode, atomRetBo.getDicMap());
        }
        return dicMap;
    }

    private Page<RsDataBaseQueryPo> getPage(RsDatabasePageQueryBusiReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

