/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.oss.McmpOssDeleteOssBucketService;
import com.tydic.mcmp.intf.api.oss.bo.McmpOssDeleteOssBucketReqBO;
import com.tydic.mcmp.intf.api.oss.bo.McmpOssDeleteOssBucketRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsDeleteOssBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsDeleteOssBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsDeleteOssBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceObjectStorageMapper;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsDeleteOssBusiServiceImpl
implements RsDeleteOssBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsDeleteOssBusiServiceImpl.class);
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceObjectStorageMapper rsInfoResourceObjectStorageMapper;
    @Autowired
    private McmpOssDeleteOssBucketService mcmpOssDeleteOssBucketService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsDeleteOssBusiRspBo deleteOss(RsDeleteOssBusiReqBo busiReqBo) {
        RsDeleteOssBusiRspBo busiRspBo = new RsDeleteOssBusiRspBo();
        int count = this.rsInfoResourceMapper.deleteByPrimaryKey(busiReqBo.getOssResourceId());
        if (count != 1) {
            throw new McmpBusinessException("24011", " \u5220\u9664\u8d44\u6e90\u8868\u4fe1\u606f\u5931\u8d25");
        }
        int count1 = this.rsInfoResourceObjectStorageMapper.deleteByPrimaryKey(busiReqBo.getOssResourceId());
        if (count1 != 1) {
            throw new McmpBusinessException("24011", " \u5220\u9664\u5b58\u50a8\u5bf9\u8c61\u8868\u4fe1\u606f\u5931\u8d25");
        }
        this.invokeCreateOssBucket(busiReqBo);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u5220\u9664\u5bf9\u8c61\u5b58\u50a8\u6210\u529f");
        return busiRspBo;
    }

    private void invokeCreateOssBucket(RsDeleteOssBusiReqBo busiReqBo) {
        McmpOssDeleteOssBucketReqBO mcmpOssDeleteOssBucketReqBO = new McmpOssDeleteOssBucketReqBO();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        mcmpOssDeleteOssBucketReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpOssDeleteOssBucketReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpOssDeleteOssBucketReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpOssDeleteOssBucketReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpOssDeleteOssBucketReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpOssDeleteOssBucketReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpOssDeleteOssBucketReqBO.setRegion(busiReqBo.getRegionId());
        mcmpOssDeleteOssBucketReqBO.setBucketName(busiReqBo.getBucketName());
        log.info("\u8c03\u7528\u5bf9\u8c61\u5b58\u50a8\u5220\u9664PI\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpOssDeleteOssBucketReqBO));
        McmpOssDeleteOssBucketRspBO mcmpOssDeleteOssBucketRspBO = this.mcmpOssDeleteOssBucketService.deleteOssBucket(mcmpOssDeleteOssBucketReqBO);
        log.info("\u8c03\u7528\u5bf9\u8c61\u5b58\u50a8\u5220\u9664API\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpOssDeleteOssBucketRspBO));
        if (!"0000".equals(mcmpOssDeleteOssBucketRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpOssDeleteOssBucketRspBO.getRespCode(), mcmpOssDeleteOssBucketRspBO.getRespDesc());
        }
    }
}

