/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerAttachDiskService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerAttachDiskReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerAttachDiskRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsMountHardDiskBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsMountHardDiskBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsMountHardDiskBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsRelHostHardDiskMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostHardDiskPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsMountHardDiskBusiServiceImpl
implements RsMountHardDiskBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsMountHardDiskBusiServiceImpl.class);
    @Autowired
    private RsRelHostHardDiskMapper rsRelHostHardDiskMapper;
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private McmpCloudSerAttachDiskService mcmpCloudSerAttachDiskService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsMountHardDiskBusiRspBo dealMountHardDisk(RsMountHardDiskBusiReqBo busiReqBo) {
        RsMountHardDiskBusiRspBo busiRspBo = new RsMountHardDiskBusiRspBo();
        this.operateHardDiskInfo(busiReqBo);
        this.invokeAttachDisk(busiReqBo);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u4e91\u76d8\u6302\u8f7d\u6210\u529f");
        return busiRspBo;
    }

    private void operateHardDiskInfo(RsMountHardDiskBusiReqBo busiReqBo) {
        RsInfoHardDiskPo rsInfoHardDiskPo = new RsInfoHardDiskPo();
        rsInfoHardDiskPo.setHdResourceId(busiReqBo.getHdResourceId());
        rsInfoHardDiskPo.setHdStatus(RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_STATUS_USING);
        int count1 = this.rsInfoHardDiskMapper.updateByPrimaryKeySelective(rsInfoHardDiskPo);
        if (count1 != 1) {
            throw new McmpBusinessException("24012", "\u4e91\u76d8\u4fe1\u606f\u8868\u4fee\u6539\u5931\u8d25");
        }
        RsRelHostHardDiskPo rsRelHostHardDiskPo = new RsRelHostHardDiskPo();
        rsRelHostHardDiskPo.setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_HOST_HARD_DISK.toString()));
        rsRelHostHardDiskPo.setHostResourceId(busiReqBo.getHostResourceId());
        rsRelHostHardDiskPo.setHdResourceId(busiReqBo.getHdResourceId());
        int count = this.rsRelHostHardDiskMapper.insertSelective(rsRelHostHardDiskPo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u4e3b\u673a\u4e91\u76d8\u5173\u7cfb\u8868\u65b0\u589e\u5931\u8d25");
        }
    }

    private void invokeAttachDisk(RsMountHardDiskBusiReqBo busiReqBo) {
        McmpCloudSerAttachDiskReqBO mcmpCloudSerAttachDiskReqBO = new McmpCloudSerAttachDiskReqBO();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        mcmpCloudSerAttachDiskReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpCloudSerAttachDiskReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpCloudSerAttachDiskReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpCloudSerAttachDiskReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpCloudSerAttachDiskReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpCloudSerAttachDiskReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpCloudSerAttachDiskReqBO.setDiskId(busiReqBo.getHdInstanceId());
        mcmpCloudSerAttachDiskReqBO.setInstanceId(busiReqBo.getHostInstanceId());
        mcmpCloudSerAttachDiskReqBO.setBootable(busiReqBo.getBootable());
        mcmpCloudSerAttachDiskReqBO.setRegion(busiReqBo.getRegion());
        log.info("\u4e91\u4e3b\u673a\u6302\u8f7d\u4e91\u76d8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerAttachDiskReqBO));
        McmpCloudSerAttachDiskRspBO mcmpCloudSerAttachDiskRspBO = this.mcmpCloudSerAttachDiskService.attachDisk(mcmpCloudSerAttachDiskReqBO);
        log.info("\u4e91\u4e3b\u673a\u6302\u8f7d\u4e91\u76d8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerAttachDiskRspBO));
        if (!"0000".equals(mcmpCloudSerAttachDiskRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpCloudSerAttachDiskRspBO.getRespCode(), mcmpCloudSerAttachDiskRspBO.getRespDesc());
        }
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

