/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.busi.api.RsPlatformInstanceSpecListQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsPlatformInstanceSpecListQueryBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsPlatformInstanceSpecListQueryBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsPlatformInstanceSpecDataBo;
import com.tydic.mcmp.resource.dao.RsInfoAliDbSpecMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoAliDbSpecPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsPlatformInstanceSpecListQueryBusiService")
public class RsPlatformInstanceSpecListQueryBusiServiceImpl
implements RsPlatformInstanceSpecListQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoAliDbSpecMapper rsInfoAliDbSpecMapper;

    public RsPlatformInstanceSpecListQueryBusiRspBo qryInsSpecs(RsPlatformInstanceSpecListQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5b9e\u4f8b\u89c4\u683c\u5217\u8868\u67e5\u8be2 Busi\u670d\u52a1\uff1a" + reqBo);
        RsPlatformInstanceSpecListQueryBusiRspBo retBo = new RsPlatformInstanceSpecListQueryBusiRspBo();
        ArrayList<RsPlatformInstanceSpecDataBo> instanceSpecs = new ArrayList<RsPlatformInstanceSpecDataBo>();
        retBo.setInstanceSpecs(instanceSpecs);
        RsInfoAliDbSpecPo reqPo = new RsInfoAliDbSpecPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        List<RsInfoAliDbSpecPo> specList = this.rsInfoAliDbSpecMapper.selectByCondition(reqPo);
        if (CollectionUtils.isEmpty(specList)) {
            this.LOGGER.error("\u67e5\u8be2\u5b9e\u4f8b\u89c4\u683c\u8fd4\u56de\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u67e5\u8be2\u5b9e\u4f8b\u89c4\u683c\u8fd4\u56de\u4e3a\u7a7a");
            return retBo;
        }
        for (RsInfoAliDbSpecPo spec : specList) {
            RsPlatformInstanceSpecDataBo specDataBo = new RsPlatformInstanceSpecDataBo();
            specDataBo.setInstanceSpec(spec.getSpecId());
            specDataBo.setInstanceSpecDesc(spec.getCpuNo() + "\u6838-" + spec.getMemorySize() + "GB");
            specDataBo.setCpuNo(spec.getCpuNo());
            specDataBo.setMemorySize(spec.getMemorySize());
            instanceSpecs.add(specDataBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }
}

