/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsQueryOssListBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsQueryOssListBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsQueryOssListBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsInfoResourceObjectStorageBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceObjectStorageMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceObjectStoragePo;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RsQueryOssListBusiServiceImpl
implements RsQueryOssListBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsQueryOssListBusiServiceImpl.class);
    @Autowired
    private RsInfoResourceObjectStorageMapper rsInfoResourceObjectStorageMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public RsQueryOssListBusiRspBo queryOssList(RsQueryOssListBusiReqBo busiReqBo) {
        RsQueryOssListBusiRspBo busiRspBo = new RsQueryOssListBusiRspBo();
        RsInfoResourceObjectStoragePo objectStoragePo = new RsInfoResourceObjectStoragePo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)objectStoragePo);
        Page page = new Page(busiReqBo.getPageNo().intValue(), busiReqBo.getPageSize().intValue());
        List<RsInfoResourceObjectStorageBo> rows = busiReqBo.getPageQryFlag() != false ? this.rsInfoResourceObjectStorageMapper.selectPageByRecord((Page<RsInfoResourceObjectStorageBo>)page, objectStoragePo) : this.rsInfoResourceObjectStorageMapper.selectListByRecord(objectStoragePo);
        if (!CollectionUtils.isEmpty(rows)) {
            this.translate(rows);
        }
        busiRspBo.setRows(rows);
        busiRspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        busiRspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        busiRspBo.setPageNo(Integer.valueOf(page.getPageNo()));
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return busiRspBo;
    }

    private void translate(List<RsInfoResourceObjectStorageBo> rows) {
        RsDicMapQueryAtomReqBo rsDicMapQueryAtomReqBo = new RsDicMapQueryAtomReqBo();
        rsDicMapQueryAtomReqBo.setType("RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE");
        RsDicMapQueryAtomRspBo bo1 = this.rsDicMapQueryAtomService.qryDicMap(rsDicMapQueryAtomReqBo);
        Map<String, String> ossTypeMap = bo1.getDicMap();
        rsDicMapQueryAtomReqBo.setType("RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY");
        RsDicMapQueryAtomRspBo bo2 = this.rsDicMapQueryAtomService.qryDicMap(rsDicMapQueryAtomReqBo);
        Map<String, String> readAuthorityMap = bo2.getDicMap();
        rsDicMapQueryAtomReqBo.setType("RS_PLATFORM_ID");
        RsDicMapQueryAtomRspBo bo3 = this.rsDicMapQueryAtomService.qryDicMap(rsDicMapQueryAtomReqBo);
        Map<String, String> platformIdMap = bo3.getDicMap();
        for (RsInfoResourceObjectStorageBo bo : rows) {
            if (bo.getOssType() != null) {
                bo.setOssTypeStr(ossTypeMap.get(bo.getOssType().toString()));
            }
            if (bo.getReadAuthority() != null) {
                bo.setReadAuthorityStr(readAuthorityMap.get(bo.getReadAuthority().toString()));
            }
            if (bo.getPlatformId() == null) continue;
            bo.setPlatformIdStr(platformIdMap.get(bo.getPlatformId().toString()));
        }
    }
}

