/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.busi.api.RsRedisCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsRedisCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsRedisCreateBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceRedisMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceRedisPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsRedisCreateBusiService")
public class RsRedisCreateBusiServiceImpl
implements RsRedisCreateBusiService {
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceRedisMapper rsInfoResourceRedisMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsRedisCreateBusiServiceImpl.class);

    public RsRedisCreateBusiRspBo dealRsRedisCreate(RsRedisCreateBusiReqBo reqBo) {
        RsRedisCreateBusiRspBo rspBo = RsRspBoUtil.genSuccessBo(RsRedisCreateBusiRspBo.class);
        Long resourceId = 0L;
        try {
            resourceId = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
            return rspBo;
        }
        try {
            RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
            BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoResourcePo);
            rsInfoResourcePo.setResourceId(resourceId);
            rsInfoResourcePo.setServiceId(4L);
            rsInfoResourcePo.setInstanceId(reqBo.getInstanceId());
            this.rsInfoResourceMapper.insert(rsInfoResourcePo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u521b\u5efa\u8d44\u6e90\u5931\u8d25");
            return rspBo;
        }
        try {
            RsInfoResourceRedisPo rsInfoResourceRedisPo = new RsInfoResourceRedisPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoResourceRedisPo);
            rsInfoResourceRedisPo.setCacheResourceId(resourceId);
            rsInfoResourceRedisPo.setInstanceId(reqBo.getInstanceId());
            this.rsInfoResourceRedisMapper.insert(rsInfoResourceRedisPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u521b\u5efa\u7f13\u5b58\u5931\u8d25");
            return rspBo;
        }
        return rspBo;
    }
}

