/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.busi.api.RsTenementQuotaBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsTenementQuotaListBo;
import com.tydic.mcmp.resource.busi.api.bo.RsTenementQuotaQryListBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsTenementQuotaQryListBusiRspBo;
import com.tydic.mcmp.resource.busi.api.bo.RsTenementQuotaSaveBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsTenementQuotaSaveBusiRspBo;
import com.tydic.mcmp.resource.constants.RsPlatformConstants;
import com.tydic.mcmp.resource.dao.RsInfoPlatformMapper;
import com.tydic.mcmp.resource.dao.RsRelTenementQuotaMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPlatformPo;
import com.tydic.mcmp.resource.dao.po.RsRelTenementQuotaPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsTenementQuotaBusiServiceImpl
implements RsTenementQuotaBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoPlatformMapper rsInfoPlatformMapper;
    @Autowired
    private RsRelTenementQuotaMapper rsRelTenementQuotaMapper;
    @Autowired
    private SequenceManagement sequenceManagement;

    public RsTenementQuotaQryListBusiRspBo getRsTenementQuotaList(RsTenementQuotaQryListBusiReqBo reqBo) {
        RsTenementQuotaQryListBusiRspBo rspBo = new RsTenementQuotaQryListBusiRspBo();
        ArrayList<RsTenementQuotaListBo> rsTenementQuotaList = new ArrayList<RsTenementQuotaListBo>();
        RsInfoPlatformPo platformCondition = new RsInfoPlatformPo();
        platformCondition.setPlatformStatus(RsPlatformConstants.status.VALID);
        List<RsInfoPlatformPo> rsInfoPlatformList = this.rsInfoPlatformMapper.queryList(platformCondition);
        RsRelTenementQuotaPo quotaCondition = new RsRelTenementQuotaPo();
        quotaCondition.setTenementId(reqBo.getTenementIdWeb());
        List<RsRelTenementQuotaPo> quotaList = this.rsRelTenementQuotaMapper.queryList(quotaCondition);
        for (RsInfoPlatformPo rsInfoPlatformPo : rsInfoPlatformList) {
            boolean noneFlag = true;
            RsTenementQuotaListBo Bo = new RsTenementQuotaListBo();
            for (RsRelTenementQuotaPo quotaPo : quotaList) {
                if (!quotaPo.getPlatformId().equals(rsInfoPlatformPo.getPlatformId())) continue;
                noneFlag = false;
                BeanUtils.copyProperties((Object)quotaPo, (Object)Bo);
                Bo.setPlatformName(rsInfoPlatformPo.getPlatformName());
                break;
            }
            if (noneFlag) {
                Bo.setPlatformId(rsInfoPlatformPo.getPlatformId());
                Bo.setPlatformName(rsInfoPlatformPo.getPlatformName());
            }
            rsTenementQuotaList.add(Bo);
        }
        rspBo.setRsTenementQuotaList(rsTenementQuotaList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBo;
    }

    public RsTenementQuotaSaveBusiRspBo saveRsTenementQuota(RsTenementQuotaSaveBusiReqBo reqBo) {
        RsTenementQuotaSaveBusiRspBo rspBo = new RsTenementQuotaSaveBusiRspBo();
        try {
            List RsTenementQuotaList = reqBo.getRsTenementQuotaList();
            for (RsTenementQuotaListBo quotaBo : RsTenementQuotaList) {
                RsRelTenementQuotaPo po = new RsRelTenementQuotaPo();
                BeanUtils.copyProperties((Object)quotaBo, (Object)po);
                po.setUpdateTime(new Date());
                if (quotaBo.getQuotaId() == null) {
                    Long id = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
                    po.setQuotaId(id);
                    po.setCreateTime(new Date());
                    this.rsRelTenementQuotaMapper.insert(po);
                    continue;
                }
                this.rsRelTenementQuotaMapper.updateByPrimaryKey(po);
            }
        }
        catch (Exception e) {
            this.LOGGER.debug("\u79df\u6237\u914d\u989d\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            throw new McmpBusinessException("24013", "\u79df\u6237\u914d\u989d\u4fdd\u5b58\u5931\u8d25");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u79df\u6237\u914d\u989d\u4fdd\u5b58\u6210\u529f");
        return rspBo;
    }
}

