/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDetachDiskService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDetachDiskReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDetachDiskRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsUninstallHardDiskBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsUninstallHardDiskBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsUninstallHardDiskBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsRelHostHardDiskMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostHardDiskPo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsUninstallHardDiskBusiServiceImpl
implements RsUninstallHardDiskBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsUninstallHardDiskBusiServiceImpl.class);
    @Autowired
    private RsRelHostHardDiskMapper rsRelHostHardDiskMapper;
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpCloudSerDetachDiskService mcmpCloudSerDetachDiskService;

    public RsUninstallHardDiskBusiRspBo dealUninstallHardDisk(RsUninstallHardDiskBusiReqBo busiReqBo) {
        RsUninstallHardDiskBusiRspBo busiRspBo = new RsUninstallHardDiskBusiRspBo();
        this.operateHardDiskInfo(busiReqBo);
        this.invokeDetachDisk(busiReqBo);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u78c1\u76d8\u5378\u8f7d\u6210\u529f");
        return busiRspBo;
    }

    private void invokeDetachDisk(RsUninstallHardDiskBusiReqBo busiReqBo) {
        McmpCloudSerDetachDiskReqBO mcmpCloudSerDetachDiskReqBO = new McmpCloudSerDetachDiskReqBO();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        mcmpCloudSerDetachDiskReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpCloudSerDetachDiskReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpCloudSerDetachDiskReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpCloudSerDetachDiskReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpCloudSerDetachDiskReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpCloudSerDetachDiskReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpCloudSerDetachDiskReqBO.setDiskId(busiReqBo.getHdInstanceId());
        mcmpCloudSerDetachDiskReqBO.setInstanceId(busiReqBo.getHostInstanceId());
        mcmpCloudSerDetachDiskReqBO.setRegion(busiReqBo.getRegion());
        log.info("\u4e91\u4e3b\u673a\u5378\u8f7d\u4e91\u76d8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDetachDiskReqBO));
        McmpCloudSerDetachDiskRspBO mcmpCloudSerDetachDiskRspBO = this.mcmpCloudSerDetachDiskService.detachDisk(mcmpCloudSerDetachDiskReqBO);
        log.info("\u4e91\u4e3b\u673a\u5378\u8f7d\u4e91\u76d8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDetachDiskRspBO));
        if (!"0000".equals(mcmpCloudSerDetachDiskRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpCloudSerDetachDiskRspBO.getRespCode(), mcmpCloudSerDetachDiskRspBO.getRespDesc());
        }
    }

    private void operateHardDiskInfo(RsUninstallHardDiskBusiReqBo busiReqBo) {
        RsInfoHardDiskPo rsInfoHardDiskPo = new RsInfoHardDiskPo();
        rsInfoHardDiskPo.setHdResourceId(busiReqBo.getHdResourceId());
        rsInfoHardDiskPo.setHdStatus(RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_STATUS_FREE);
        int count1 = this.rsInfoHardDiskMapper.updateByPrimaryKeySelective(rsInfoHardDiskPo);
        if (count1 != 1) {
            throw new McmpBusinessException("24012", "\u4e91\u76d8\u4fe1\u606f\u8868\u4fee\u6539\u5931\u8d25");
        }
        RsRelHostHardDiskPo rsRelHostHardDiskPo = new RsRelHostHardDiskPo();
        rsRelHostHardDiskPo.setHdResourceId(busiReqBo.getHdResourceId());
        rsRelHostHardDiskPo.setHostResourceId(busiReqBo.getHostResourceId());
        int count = this.rsRelHostHardDiskMapper.deleteByRecord(rsRelHostHardDiskPo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u4e3b\u673a\u4e91\u76d8\u5173\u7cfb\u8868\u5220\u9664\u5931\u8d25");
        }
    }
}

