/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.config.redis;

import com.tydic.mcmp.resource.config.redis.RsRedisUtil;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RsCacheManager {
    @Autowired
    private RsRedisUtil rsRedisUtil;
    @Value(value="${rs.cache.time:900}")
    private long time;
    private final String RS_ALL_KEYS_KEY = "RS_ALL_KEYS_KEY";

    public boolean set(String key, Object value) {
        return this.set(key, value, this.time);
    }

    public boolean set(String key, Object value, long cacheTime) {
        boolean set = this.rsRedisUtil.set(key, value, cacheTime);
        if (set) {
            this.rsRedisUtil.sSet("RS_ALL_KEYS_KEY", key);
        }
        return set;
    }

    public <T> T getObject(String key, Class<T> clazz) {
        return this.rsRedisUtil.getObject(key, clazz);
    }

    public boolean cleanCache() {
        Set<Object> objects = this.rsRedisUtil.sGet("RS_ALL_KEYS_KEY");
        for (Object object : objects) {
            String deleteKey = (String)object;
            this.rsRedisUtil.del(deleteKey);
            this.rsRedisUtil.setRemove("RS_ALL_KEYS_KEY", deleteKey);
        }
        return true;
    }
}

