/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeRegionsService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeRegionsReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeRegionsRspBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerRegionsBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsAliHostRegionQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostRegionQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostRegionQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostRegionQueryAbilityRspRegionBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsAliHostRegionQueryAbilityService"})
public class RsAliHostRegionQueryAbilityServiceImpl
implements RsAliHostRegionQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsAliHostRegionQueryAbilityServiceImpl.class);
    @Autowired
    private McmpCloudSerDescribeRegionsService mcmpCloudSerDescribeRegionsService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"queryAliHostRegion"})
    public RsAliHostRegionQueryAbilityRspBo queryAliHostRegion(@RequestBody RsAliHostRegionQueryAbilityReqBo reqBo) {
        RsAliHostRegionQueryAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsAliHostRegionQueryAbilityRspBo.class);
        String validateArgStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            return RsRspBoUtil.genFailedBo(RsAliHostRegionQueryAbilityRspBo.class, "\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr, "8887");
        }
        if (1L == reqBo.getPlatformId() && reqBo.getPayType() == null) {
            return RsRspBoUtil.genFailedBo(RsAliHostRegionQueryAbilityRspBo.class, "\u516c\u6709\u4e91\u5fc5\u987b\u8981\u4f20\u5165\u4ed8\u8d39\u7c7b\u578b");
        }
        RsQueryAliParamAtomReqBo qryParam = new RsQueryAliParamAtomReqBo();
        qryParam.setAccountId(reqBo.getAccountId());
        qryParam.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo paramAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(qryParam);
        if (!"0000".equals(paramAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsAliHostRegionQueryAbilityRspBo.class, paramAtomRspBo.getRespDesc(), paramAtomRspBo.getRespCode());
        }
        McmpCloudSerDescribeRegionsReqBO queryRegion = new McmpCloudSerDescribeRegionsReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryRegion);
        queryRegion.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        if (1L == reqBo.getPlatformId()) {
            queryRegion.setInstanceChargeType(RsInterfaceUtil.convertAliHostPayType(reqBo.getPayType()));
        }
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)queryRegion);
        log.debug("\u67e5\u8be2\u533a\u57df\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSON((Object)queryRegion));
        McmpCloudSerDescribeRegionsRspBO mcmpCloudSerDescribeRegionsRspBO = this.mcmpCloudSerDescribeRegionsService.describeRegions(queryRegion);
        log.debug("\u67e5\u8be2\u533a\u57df\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSON((Object)mcmpCloudSerDescribeRegionsRspBO));
        if (!"0000".equals(mcmpCloudSerDescribeRegionsRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsAliHostRegionQueryAbilityRspBo.class, mcmpCloudSerDescribeRegionsRspBO.getRespDesc(), mcmpCloudSerDescribeRegionsRspBO.getRespCode());
        }
        ArrayList<RsAliHostRegionQueryAbilityRspRegionBo> regionsList = new ArrayList<RsAliHostRegionQueryAbilityRspRegionBo>();
        rspBo.setRegions(regionsList);
        String statusNo = "soldOut";
        if (!CollectionUtil.isEmpty((Collection)mcmpCloudSerDescribeRegionsRspBO.getRows())) {
            for (McmpCloudSerRegionsBO regionBo : mcmpCloudSerDescribeRegionsRspBO.getRows()) {
                if (statusNo.equals(regionBo.getStatus())) continue;
                RsAliHostRegionQueryAbilityRspRegionBo regionRspBo = new RsAliHostRegionQueryAbilityRspRegionBo();
                regionRspBo.setRegionID(regionBo.getRegionId());
                regionRspBo.setRegionName(StrUtil.isEmpty((CharSequence)regionBo.getLocalName()) ? regionBo.getRegionId() : regionBo.getLocalName());
                regionRspBo.setRegionEndpoint(regionBo.getRegionEndpoint());
                regionsList.add(regionRspBo);
            }
        }
        return rspBo;
    }
}

